/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.exception.web.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.exception.web.ErrorCode;
import com.kevinkda.core.util.exception.web.enumeration.EnumErrorCode;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.context.annotation.Primary;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Service;

@Primary
@Service
public class ErrorCodeByJsonImpl
implements ErrorCode,
Serializable {
    @JSONField(name="errcode", ordinal=1, serialize=true, deserialize=true)
    private int code;
    @JSONField(name="errmsg", ordinal=2, serialize=true, deserialize=true)
    private String message;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    @JSONField(name="dateTime", ordinal=3, format="yyyy-MM-dd HH:mm:ss.SSS", serialize=true, deserialize=true)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private Date upTime;
    @JSONField(name="data", ordinal=4, serialize=true, deserialize=true)
    private JSONObject backData = new JSONObject();

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/10/16 12:10")
    public void setErrorCode(EnumErrorCode code) {
        this.setCode(code.getCode());
        this.setMessage(code.getMessage());
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/10/16 13:18")
    public void putData(String key, Object value) {
        this.backData.put(key, value);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/10/16 13:18")
    public void putAllData(Map<String, ?> data) {
        this.backData.putAll(data);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/10/16 13:22")
    private void isUpTimeNull() {
        if (this.upTime == null) {
            this.upTime = new Date(System.currentTimeMillis());
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/10/16 13:46")
    public Object toJson() {
        this.isUpTimeNull();
        return JSONObject.toJSON((Object)this);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/16 14:05")
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("errcode", this.code);
        map.put("errmsg", this.message);
        map.put("dateTime", this.upTime);
        map.put("data", this.backData.getInnerMap());
        return map;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/10/16 13:47")
    public String toJsonString() {
        this.isUpTimeNull();
        return JSON.toJSONString((Object)this);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/10/16 13:49")
    public String toJsonpString(String callback) {
        this.isUpTimeNull();
        return callback + "(" + this.toJson() + ")";
    }

    public ErrorCodeByJsonImpl(int code, String message, JSONObject backData) {
        this.code = code;
        this.message = message;
        this.backData = backData;
    }

    public String toString() {
        return "ErrorCodeByJsonImpl{code=" + this.code + ", message='" + this.message + '\'' + ", upTime=" + this.upTime + ", backData='" + this.backData + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorCodeByJsonImpl)) {
            return false;
        }
        ErrorCodeByJsonImpl that = (ErrorCodeByJsonImpl)o;
        return this.getCode() == that.getCode() && this.getMessage().equals(that.getMessage()) && this.getUpTime().equals(that.getUpTime()) && this.getBackData().equals((Object)that.getBackData());
    }

    public int hashCode() {
        return Objects.hash(this.getCode(), this.getMessage(), this.getUpTime(), this.getBackData());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Date getUpTime() {
        return this.upTime;
    }

    @Override
    public JSONObject getBackData() {
        return this.backData;
    }

    @Override
    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setUpTime(Date upTime) {
        this.upTime = upTime;
    }

    @Override
    public void setBackData(JSONObject backData) {
        this.backData = backData;
    }

    public ErrorCodeByJsonImpl(int code, String message, Date upTime, JSONObject backData) {
        this.code = code;
        this.message = message;
        this.upTime = upTime;
        this.backData = backData;
    }

    public ErrorCodeByJsonImpl() {
    }
}

