/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.verification.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.config.VerifyCodeConfig;
import com.kevinkda.core.util.util.verification.VerifyCodeService;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import org.springframework.stereotype.Service;

@Service
public class VerifyCodeServiceImpl
extends VerifyCodeConfig
implements VerifyCodeService {
    public String strText;

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 15:39")
    public BufferedImage getImage() {
        BufferedImage image = this.createImage();
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String s = this.randomChar() + "";
            stringBuilder.append(s);
            float x = (float)i * 1.0f * 70.0f / 4.0f;
            graphics2D.setFont(this.randomFont());
            graphics2D.setColor(this.randomColor());
            graphics2D.drawString(s, x, 30.0f);
        }
        this.strText = stringBuilder.toString();
        this.drawLine(image);
        return image;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 15:47")
    public void output(BufferedImage image, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)image, "JPEG", out);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 16:17")
    public int verify(String userCode) {
        if (userCode.toLowerCase().equals(this.strText.toLowerCase())) {
            return 1;
        }
        if ("".equals(userCode.trim())) {
            return -1;
        }
        return 0;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 15:10")
    private Color randomColor() {
        int red = this.random.nextInt(150);
        int green = this.random.nextInt(150);
        int blue = this.random.nextInt(150);
        return new Color(red, green, blue);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 15:17")
    private Font randomFont() {
        int index = this.random.nextInt(this.fontNames.length);
        String fontName = this.fontNames[index];
        int style = this.random.nextInt(4);
        int size = this.random.nextInt(5) + 24;
        return new Font(fontName, style, size);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 15:23")
    private void drawLine(BufferedImage image) {
        int num = 3;
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        for (int i = 0; i < num; ++i) {
            int x1 = this.random.nextInt(70);
            int y1 = this.random.nextInt(35);
            int x2 = this.random.nextInt(70);
            int y2 = this.random.nextInt(35);
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.setColor(Color.BLUE);
            graphics2D.drawLine(x1, y1, x2, y2);
        }
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 15:27")
    private char randomChar() {
        int index = this.random.nextInt("23456789abcdefghjkmnopqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ".length());
        return "23456789abcdefghjkmnopqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ".charAt(index);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 15:28")
    private BufferedImage createImage() {
        BufferedImage image = new BufferedImage(70, 35, 1);
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.setColor(this.bgColor);
        graphics2D.fillRect(0, 0, 70, 35);
        return image;
    }

    public int getWidth() {
        return 70;
    }

    public int getHeight() {
        return 35;
    }

    public Random getRandom() {
        return this.random;
    }

    public String[] getFontNames() {
        return this.fontNames;
    }

    public String getCodes() {
        return "23456789abcdefghjkmnopqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    @Override
    public String getStrText() {
        return this.strText;
    }

    public void setStrText(String strText) {
        this.strText = strText;
    }
}

