/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.web.servlet.request;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class RequestService {
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/11 21:46")
    public List<Map<String, Object>> getParametersForText(HttpServletRequest request) {
        return new ArrayList<Map<String, Object>>(Arrays.asList(this.getRequestHead(request), this.getRequestBody(request)));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/1 14:37")
    public Map<String, Object> getRequestHead(HttpServletRequest request) {
        Enumeration requestHeaderNames = request.getHeaderNames();
        HashMap<String, Object> requestHead = new HashMap<String, Object>();
        while (requestHeaderNames.hasMoreElements()) {
            String tempKey = (String)requestHeaderNames.nextElement();
            requestHead.put(tempKey, request.getHeader(tempKey));
        }
        return requestHead;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/11 21:54")
    public Map<String, Object> getRequestBody(HttpServletRequest request) {
        Enumeration requestHeaderNames = request.getParameterNames();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        while (requestHeaderNames.hasMoreElements()) {
            String paramName = (String)requestHeaderNames.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            if (paramValues.length == 1) {
                String paramValue = paramValues[0];
                if (null == paramValue || "".equals(paramValue)) continue;
                requestBody.put(paramName, paramValue);
                continue;
            }
            if (paramValues.length <= 1) continue;
            requestBody.put(paramName, paramValues);
        }
        return requestBody;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/11 22:15")
    public void printParameters(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            System.out.println(entry.getKey() + ":" + entry.getValue());
        }
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/11 22:15")
    public String[] showParameters(Map<String, Object> map) {
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            list.add(entry.getKey() + ":" + entry.getValue());
        }
        return (String[])list.toArray();
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/1 14:30", note="\u4f9d\u8d56\u6d4b\u8bd5")
    @Deprecated
    public String getPostBody(HttpServletRequest request) {
        String bodyInfo = "";
        try {
            ServletInputStream i = request.getInputStream();
            bodyInfo = IOUtils.toString((InputStream)i, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bodyInfo;
    }

    public List<Map<String, Object>> getParametersForJson(HttpServletRequest request) {
        return null;
    }
}

