/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.io.property.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.io.property.PropertyModify;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.springframework.stereotype.Service;

@Service
public class PropertyModifyImpl
implements PropertyModify {
    private Properties properties;
    private String propertiesUrl;
    private String propertiesName;

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/24 21:47")
    public void load() throws IOException {
        this.properties = new Properties();
        try (FileInputStream fis = new FileInputStream(this.propertiesUrl);){
            this.properties.load(fis);
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/24 21:46")
    public boolean optionProperty(String key, String value) {
        try (FileOutputStream fos = new FileOutputStream(this.propertiesUrl);){
            if (this.properties == null) {
                this.load();
            }
            this.properties.setProperty(key, value);
            this.properties.store(fos, "Copyright (c) KevinKDA");
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/24 21:45")
    public boolean updateProperty(String key, String value) {
        if (this.getProperty(key) == null) {
            return false;
        }
        return this.optionProperty(key, value);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/24 21:44")
    public boolean addProperty(String key, String value) {
        if (this.getProperty(key) != null) {
            return false;
        }
        return this.optionProperty(key, value);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/24 21:43")
    public String getProperty(String key) {
        try (FileInputStream fis = new FileInputStream(this.propertiesUrl);){
            if (this.properties == null) {
                this.load();
            }
            this.properties.load(fis);
        }
        catch (IOException e) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public PropertyModifyImpl() {
    }

    public PropertyModifyImpl(String propertiesUrl) {
        this.setPropertiesUrl(propertiesUrl);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPropertiesUrl() {
        return this.propertiesUrl;
    }

    public void setPropertiesUrl(String propertiesUrl) {
        this.propertiesUrl = propertiesUrl;
        String[] urlArr = propertiesUrl.split("/");
        this.propertiesName = urlArr[urlArr.length - 1];
    }

    public String getPropertiesName() {
        return this.propertiesName;
    }

    public void setPropertiesName(String propertiesName) {
        this.propertiesName = propertiesName;
    }
}

