/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.db.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.db.Jdbc;
import com.kevinkda.core.util.util.db.PageBean;
import com.kevinkda.core.util.util.db.util.SqlStringHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageBeanImpl
implements PageBean {
    @Autowired
    private Jdbc jdbc;
    @Autowired
    private SqlStringHelper sqlStringHelper;
    private int intPageCode;
    private int intTotalPage;
    private int intTotalRecord;
    private int intPageSize;
    private int intPageColumnSize;
    private String sql;
    private Object[] conditionValue;

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:49")
    public ResultSet getResultSet(String sql) {
        return this.getResultSet(sql, null);
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:51")
    public ResultSet getResultSet(String sql, Object[] conditionValue) {
        this.sql = sql;
        this.conditionValue = conditionValue;
        return this.jdbc.getResultSet(this.sqlStringHelper.appendPageString(new StringBuilder(sql), this.intPageCode, this.intPageSize).toString(), conditionValue);
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:52")
    public ResultSet getResultSet(String[] strTable, String[] strColumn, String[] strConditionColumn, Object[] conditionValue) {
        StringBuilder stringBuilder = this.sqlStringHelper.appendSqlString(strTable, strColumn, strConditionColumn);
        return this.getResultSet(stringBuilder.toString(), conditionValue);
    }

    @Override
    @FuncVerification(version="1.2.0", status=VerifiedType.Unverified, date="2020/4/27 23:28")
    public List<Map<String, Object>> getResultListMap(String sql) {
        return this.jdbc.getListMap(this.getResultSet(sql, null));
    }

    @Override
    @FuncVerification(version="1.2.0", status=VerifiedType.Unverified, date="2020/4/27 23:32")
    public List<Map<String, Object>> getResultListMap(String sql, Object[] conditionValue) {
        return this.jdbc.getListMap(this.getResultSet(sql, conditionValue));
    }

    @Override
    @FuncVerification(version="1.2.0", status=VerifiedType.Unverified, date="2020/4/27 23:33")
    public List<Map<String, Object>> getResultListMap(String[] strTable, String[] strColumn, String[] strConditionColumn, Object[] conditionValue) {
        return this.jdbc.getListMap(this.getResultSet(strTable, strColumn, strConditionColumn, conditionValue));
    }

    @Override
    @FuncVerification(version="1.2.0", status=VerifiedType.Unverified, date="2020/4/27 23:51")
    public int getResultSetCountRow(String sql) {
        return this.getResultSetCountRow(sql, null);
    }

    @Override
    @FuncVerification(version="1.2.0", status=VerifiedType.Unverified, date="2020/4/27 23:51")
    public int getResultSetCountRow(String sql, Object[] conditionValue) {
        int count = 0;
        try {
            ResultSet resultSet = this.jdbc.getResultSet(sql, conditionValue);
            resultSet.next();
            count = resultSet.getInt(1);
            this.setIntTotalPage();
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:17")
    public boolean last() {
        if (this.intPageCode > 1) {
            --this.intPageCode;
            return true;
        }
        return false;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:23")
    public boolean next() {
        if (this.intPageCode < this.intTotalPage) {
            ++this.intPageCode;
            return true;
        }
        return false;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:29")
    public ResultSet lastResultSet() {
        if (this.last()) {
            return this.getResultSet(this.sql, this.conditionValue);
        }
        return null;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:30")
    public ResultSet nextResultSet() {
        if (this.next()) {
            return this.getResultSet(this.sql, this.conditionValue);
        }
        return null;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:32")
    public List<Map<String, Object>> lastPageMap() {
        if (this.last()) {
            return this.jdbc.getListMap(this.getResultSet(this.sql, this.conditionValue));
        }
        return null;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 22:35")
    public List<Map<String, Object>> nextPageMap() {
        if (this.next()) {
            return this.jdbc.getListMap(this.getResultSet(this.sql, this.conditionValue));
        }
        return null;
    }

    public PageBeanImpl() {
        this.intPageCode = 1;
        this.intPageSize = 20;
    }

    public PageBeanImpl(String sqlCount) {
        this.intTotalRecord = this.getResultSetCountRow(sqlCount);
    }

    public PageBeanImpl(int intPageSize, String sqlCount) {
        this.intPageSize = intPageSize;
        this.intTotalRecord = this.getResultSetCountRow(sqlCount);
    }

    public PageBeanImpl(int intPageSize, String sqlCount, Object[] conditionValue) {
        this.intPageSize = intPageSize;
        this.intTotalRecord = this.getResultSetCountRow(sqlCount, conditionValue);
    }

    public PageBeanImpl(String sqlCount, Object[] conditionValue) {
        this.intTotalRecord = this.getResultSetCountRow(sqlCount, conditionValue);
    }

    public PageBeanImpl(int intPageCode, int intTotalRecord, int intPageSize) {
        this.intPageCode = intPageCode;
        this.setIntTotalPage();
        this.intTotalRecord = intTotalRecord;
        this.intPageSize = intPageSize;
    }

    @Override
    public int getIntPageCode() {
        return this.intPageCode;
    }

    @Override
    public void setIntPageCode(int intPageCode) {
        this.intPageCode = intPageCode;
    }

    @Override
    public int getIntTotalPage() {
        return this.intTotalPage;
    }

    @Override
    public void setIntTotalPage() {
        int temp = this.intTotalRecord / this.intPageSize;
        this.intTotalPage = this.intTotalRecord % this.intPageSize == 0 ? temp : temp + 1;
    }

    @Override
    public int getIntTotalRecord() {
        return this.intTotalRecord;
    }

    @Override
    public void setIntTotalRecord(int intTotalRecord) {
        this.intTotalRecord = intTotalRecord;
    }

    @Override
    public int getIntPageSize() {
        return this.intPageSize;
    }

    @Override
    public void setIntPageSize(int intPageSize) {
        this.intPageSize = intPageSize;
    }

    @Override
    public int getIntPageColumnSize() {
        return this.intPageColumnSize;
    }

    @Override
    public void setIntPageColumnSize(int intPageColumnSize) {
        this.intPageColumnSize = intPageColumnSize;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public Object[] getConditionValue() {
        return this.conditionValue;
    }

    @Override
    public void setConditionValue(Object[] conditionValue) {
        this.conditionValue = conditionValue;
    }
}

