/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.db.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.db.BeanJdbc;
import com.kevinkda.core.util.util.db.Jdbc;
import com.kevinkda.core.util.util.db.util.SqlStringHelper;
import com.kevinkda.core.util.util.string.impl.StringHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BeanJdbcImpl<T>
implements BeanJdbc {
    @Autowired
    private SqlStringHelper sqlStringHelper;
    @Autowired
    private Jdbc jdbc;

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 23:07")
    public List<T> getBean(String sql) {
        return this.getBean(sql, null);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 19:28")
    public List<T> getBean(String sql, Object[] conditionValue) {
        ResultSet resultSet = this.jdbc.getResultSet(sql, conditionValue);
        int rowCount = this.jdbc.getResultSetCountColumn(resultSet);
        ArrayList listT = new ArrayList(this.jdbc.getResultSetCountRow(resultSet));
        try {
            Constructor<?> entity = null;
            while (resultSet.next()) {
                entity = entity.getClass().getConstructor(new Class[0]);
                for (int i = 1; i < rowCount + 1; ++i) {
                    String key = resultSet.getMetaData().getColumnName(i);
                    Object value = resultSet.getObject(i);
                    BeanUtils.setProperty(entity, (String)key, (Object)value);
                }
                listT.add(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listT;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 23:16")
    public List<T> getBean(String[] strTable, String[] strColumn, String[] strConditionColumn, Object[] conditionValue) {
        StringBuilder stringBuilder = this.sqlStringHelper.appendSqlString(strTable, strColumn, strConditionColumn);
        return this.getBean(stringBuilder.toString(), conditionValue);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 23:07")
    public List<T> getBeanByClass(String sql, Class<T> clazz) {
        return this.getBeanByClass(sql, null, clazz);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 22:59")
    public List<T> getBeanByClass(String sql, Object[] conditionValue, Class<T> clazz) {
        ResultSet resultSet = this.jdbc.getResultSet(sql, conditionValue);
        int rowCount = this.jdbc.getResultSetCountColumn(resultSet);
        ArrayList<T> listT = new ArrayList<T>(this.jdbc.getResultSetCountRow(resultSet));
        try {
            while (resultSet.next()) {
                T entity = clazz.newInstance();
                for (int i = 1; i < rowCount + 1; ++i) {
                    String key = this.checkFieldName(resultSet.getMetaData().getColumnLabel(i));
                    Object value = resultSet.getObject(i);
                    BeanUtils.setProperty(entity, (String)key, (Object)value);
                }
                listT.add(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listT;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 23:07")
    public List<T> getBeanByClass(String[] strTable, String[] strColumn, String[] strConditionColumn, Object[] conditionValue, Class<T> clazz) {
        StringBuilder stringBuilder = this.sqlStringHelper.appendSqlString(strTable, strColumn, strConditionColumn);
        return this.getBeanByClass(stringBuilder.toString(), conditionValue, clazz);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 19:09")
    public List<T> getBeanByMap(String sql) {
        return this.getBeanByMap(sql, null);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 19:03")
    public List<T> getBeanByMap(String sql, Object[] conditionValue) {
        List<Map<String, Object>> mapList = this.jdbc.getResultListMap(sql, conditionValue);
        ArrayList listT = new ArrayList();
        try {
            Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            for (Map<String, Object> map : mapList) {
                Object entity = entityClass.newInstance();
                BeanUtils.populate(entity, map);
                listT.add(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listT;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 19:14")
    public List<T> getBeanByMap(String[] strTable, String[] strColumn, String[] strConditionColumn, Object[] conditionValue) {
        StringBuilder stringBuilder = this.sqlStringHelper.appendSqlString(strTable, strColumn, strConditionColumn);
        return this.getBeanByMap(stringBuilder.toString(), conditionValue);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 21:21")
    private String checkFieldName(String str) {
        if ("ID".equals(str.toUpperCase())) {
            return "id";
        }
        return StringHelper.initialLowercase(str);
    }

    public BeanJdbcImpl() {
    }

    public BeanJdbcImpl(String path) {
        this.jdbc.use(path);
    }
}

