/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.db.abstraction;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.db.Jdbc;
import java.util.ResourceBundle;

public abstract class AbstractJdbc
implements Jdbc {
    String strResourcePath;
    static int DATABASE_CURRENTLY_IN_USE = 0;
    static int BATCH_MAX = 0;
    protected int intBatchCount = 0;
    protected String driver = null;
    protected String url = null;
    protected String user = null;
    protected String pass = null;

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/27 10:48")
    public boolean use(String path) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(path);
        BATCH_MAX = Integer.parseInt(resourceBundle.getString("db.BatchMax"));
        this.driver = resourceBundle.getString("jdbc.driver");
        this.url = resourceBundle.getString("jdbc.url");
        this.user = resourceBundle.getString("jdbc.user");
        this.pass = resourceBundle.getString("jdbc.password");
        return true;
    }

    public AbstractJdbc() {
    }

    public AbstractJdbc(String path) {
        this.use(path);
    }

    public String getStrResourcePath() {
        return this.strResourcePath;
    }

    public static int getDatabaseCurrentlyInUse() {
        return DATABASE_CURRENTLY_IN_USE;
    }

    public static void setDatabaseCurrentlyInUse(int databaseCurrentlyInUse) {
        DATABASE_CURRENTLY_IN_USE = databaseCurrentlyInUse;
    }

    public static int getBatchMax() {
        return BATCH_MAX;
    }

    public static void setBatchMax(int batchMax) {
        BATCH_MAX = batchMax;
    }

    public int getIntBatchCount() {
        return this.intBatchCount;
    }

    public void setIntBatchCount(int intBatchCount) {
        this.intBatchCount = intBatchCount;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }
}

