/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.date.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.date.TimeUtil;
import org.springframework.stereotype.Service;

@Service
public class TimeUtilImpl
implements TimeUtil {
    private long startTime;
    private long endTime;
    private long duration;

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:11")
    public void startTime() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:11")
    public long stopTime() {
        this.endTime = System.currentTimeMillis();
        this.duration = this.endTime - this.startTime;
        return this.duration;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:12")
    public long getDurationByMillisecond() {
        return this.duration;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:13")
    public double getDurationBySecond() {
        return (double)this.duration / 1000.0;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:13")
    public double millisecondsToSeconds(long time) {
        return (double)time / 1000.0;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:14")
    public double millisecondsToMinute(long time) {
        return (double)time / 1000.0 / 60.0;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

