/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.bean.reflect.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.bean.reflect.MethodService;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MethodServiceImpl
implements MethodService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodServiceImpl.class);

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:56")
    public void showMethodInformation(Class<?> cls) {
        Method[] methods;
        for (Method met : methods = cls.getMethods()) {
            StringBuilder builder = new StringBuilder();
            int mod = met.getModifiers();
            builder.append(Modifier.toString(mod)).append(" ");
            builder.append(met.getReturnType().getName()).append(" ");
            builder.append(met.getName()).append("(");
            Class<?>[] params = met.getParameterTypes();
            for (int x = 0; x < params.length; ++x) {
                builder.append(params[x].getName()).append(" ").append("arg-").append(x);
                if (x >= params.length - 1) continue;
                builder.append(", ");
            }
            builder.append(")");
            Class<?>[] exp = met.getExceptionTypes();
            if (exp.length > 0) {
                builder.append(" throws ");
            }
            for (int i = 0; i < exp.length; ++i) {
                builder.append(exp[i].getName());
                if (i >= exp.length - 1) continue;
                builder.append(",");
            }
            LOGGER.info(builder.toString());
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:57")
    public List<String> getMethodInformation(Class<?> cls) {
        Method[] methods;
        ArrayList<String> list = new ArrayList<String>();
        for (Method met : methods = cls.getMethods()) {
            StringBuilder builder = new StringBuilder();
            int mod = met.getModifiers();
            builder.append(Modifier.toString(mod));
            builder.append(" ");
            builder.append(met.getReturnType().getName());
            builder.append(" ");
            builder.append(met.getName());
            builder.append("(");
            Class<?>[] params = met.getParameterTypes();
            for (int x = 0; x < params.length; ++x) {
                builder.append(params[x].getName());
                builder.append(" ");
                builder.append("arg-");
                builder.append(x);
                if (x >= params.length - 1) continue;
                builder.append(", ");
            }
            builder.append(")");
            Class<?>[] exp = met.getExceptionTypes();
            if (exp.length > 0) {
                builder.append(" throws ");
            }
            for (int i = 0; i < exp.length; ++i) {
                builder.append(exp[i].getName());
                if (i >= exp.length - 1) continue;
                builder.append(",");
            }
            list.add(builder.toString());
        }
        return list;
    }
}

