/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.security.old.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.security.old.SerializeKey;
import com.kevinkda.core.util.security.old.abstraction.AbstractKey;
import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SerializeKeyImpl
extends AbstractKey
implements SerializeKey {
    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 22:04")
    public String encode(byte[] encoded) {
        return HexBin.encode(encoded);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 22:04")
    public String encode(PrivateKey aPrivate) {
        return this.encode(aPrivate.getEncoded());
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 22:04")
    public String encode(PublicKey aPublic) {
        return this.encode(aPublic.getEncoded());
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 22:07")
    public String[] encode(KeyPair keyPair) {
        return new String[]{HexBin.encode(keyPair.getPrivate().getEncoded()), HexBin.encode(keyPair.getPrivate().getEncoded())};
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 22:15")
    public byte[] decode(String encode) {
        return HexBin.decode(encode);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 22:17")
    public List<byte[]> decode(String[] keyPair) {
        return new ArrayList<byte[]>(Arrays.asList(HexBin.decode(keyPair[0]), HexBin.decode(keyPair[1])));
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 22:17")
    public List<byte[]> decode(String publicKey, String privateKey) {
        return new ArrayList<byte[]>(Arrays.asList(HexBin.decode(publicKey), HexBin.decode(privateKey)));
    }
}

