/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.security.old.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.security.old.Keystore;
import com.kevinkda.core.util.security.old.SerializeKey;
import com.kevinkda.core.util.util.io.property.impl.PropertyModifyImpl;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KeystoreImpl
implements Keystore {
    @Autowired
    private static SerializeKey serializeKey;

    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 23:03")
    public static void saveForProperty(String path, KeyPair keyPair) {
        PropertyModifyImpl modify = new PropertyModifyImpl(path);
        modify.addProperty("public", serializeKey.encode(keyPair.getPublic()));
        modify.addProperty("private", serializeKey.encode(keyPair.getPrivate()));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 23:03")
    public static void saveForProperty(String path, PublicKey publicKey, PrivateKey privateKey) {
        PropertyModifyImpl modify = new PropertyModifyImpl(path);
        modify.addProperty("public", serializeKey.encode(publicKey.getEncoded()));
        modify.addProperty("private", serializeKey.encode(privateKey.getEncoded()));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 23:03")
    public static void saveForProperty(String path, String publicKey, String privateKey) {
        PropertyModifyImpl modify = new PropertyModifyImpl(path);
        modify.addProperty("public", publicKey);
        modify.addProperty("private", privateKey);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 23:04")
    public static String[] readFromPropertyOfString(String path) {
        PropertyModifyImpl modify = new PropertyModifyImpl(path);
        String publicKey = modify.getProperty("public");
        String privateKey = modify.getProperty("private");
        return new String[]{publicKey, privateKey};
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/26 23:06")
    public static List<byte[]> readFromProperty(String path) {
        PropertyModifyImpl modify = new PropertyModifyImpl(path);
        byte[] publicKey = serializeKey.decode(modify.getProperty("public"));
        byte[] privateKey = serializeKey.decode(modify.getProperty("private"));
        return new ArrayList<byte[]>(Arrays.asList(publicKey, privateKey));
    }
}

