/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.security.jwt.domain;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.security.jwt.config.JwtConfig;
import java.util.HashMap;
import java.util.Map;

public class Jwt
extends JwtConfig {
    private String alg;
    private String typ;
    private String iss;
    private String exp;
    private String sub;
    private String aud;
    private String nbf;
    private String iat;
    private String jti;

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 17:39")
    public void setDefaultParameters() {
        this.setDefaultHeaderParameters();
        this.setDefaultPayloadParameters();
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 17:40")
    public void setDefaultHeaderParameters() {
        if (this.alg == null || "".equals(this.alg)) {
            this.alg = ALGORITHM;
        }
        if (this.typ == null || "".equals(this.typ)) {
            this.typ = TYPE;
        }
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 17:40")
    public void setDefaultPayloadParameters() {
        if (this.iss == null || "".equals(this.iss)) {
            this.iss = ISSUER;
        }
        if (this.exp == null || "".equals(this.exp)) {
            this.exp = EXPIRATION_TIME;
        }
        if (this.sub == null || "".equals(this.sub)) {
            this.sub = SUBJECT;
        }
        if (this.aud == null || "".equals(this.aud)) {
            this.aud = AUDIENCE;
        }
        if (this.nbf == null || "".equals(this.nbf)) {
            this.nbf = NOT_BEFORE;
        }
        if (this.iat == null || "".equals(this.iat)) {
            this.iat = ISSUED_AT;
        }
        if (this.jti == null || "".equals(this.jti)) {
            this.jti = JWT_ID;
        }
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 17:31")
    public Map<String, Object> getHeaderMap() {
        this.setDefaultHeaderParameters();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alg", this.alg);
        map.put("typ", this.typ);
        return map;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 17:32")
    public Map<String, Object> getPayloadMap() {
        this.setDefaultPayloadParameters();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("iss", this.iss);
        map.put("exp", this.exp);
        map.put("sub", this.sub);
        map.put("aud", this.aud);
        map.put("nbf", this.nbf);
        map.put("iat", this.iat);
        map.put("jti", this.jti);
        return map;
    }

    public String getAlg() {
        return this.alg;
    }

    public String getTyp() {
        return this.typ;
    }

    public String getIss() {
        return this.iss;
    }

    public String getExp() {
        return this.exp;
    }

    public String getSub() {
        return this.sub;
    }

    public String getAud() {
        return this.aud;
    }

    public String getNbf() {
        return this.nbf;
    }

    public String getIat() {
        return this.iat;
    }

    public String getJti() {
        return this.jti;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public void setTyp(String typ) {
        this.typ = typ;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public void setAud(String aud) {
        this.aud = aud;
    }

    public void setNbf(String nbf) {
        this.nbf = nbf;
    }

    public void setIat(String iat) {
        this.iat = iat;
    }

    public void setJti(String jti) {
        this.jti = jti;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jwt)) {
            return false;
        }
        Jwt other = (Jwt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alg = this.getAlg();
        String other$alg = other.getAlg();
        if (this$alg == null ? other$alg != null : !this$alg.equals(other$alg)) {
            return false;
        }
        String this$typ = this.getTyp();
        String other$typ = other.getTyp();
        if (this$typ == null ? other$typ != null : !this$typ.equals(other$typ)) {
            return false;
        }
        String this$iss = this.getIss();
        String other$iss = other.getIss();
        if (this$iss == null ? other$iss != null : !this$iss.equals(other$iss)) {
            return false;
        }
        String this$exp = this.getExp();
        String other$exp = other.getExp();
        if (this$exp == null ? other$exp != null : !this$exp.equals(other$exp)) {
            return false;
        }
        String this$sub = this.getSub();
        String other$sub = other.getSub();
        if (this$sub == null ? other$sub != null : !this$sub.equals(other$sub)) {
            return false;
        }
        String this$aud = this.getAud();
        String other$aud = other.getAud();
        if (this$aud == null ? other$aud != null : !this$aud.equals(other$aud)) {
            return false;
        }
        String this$nbf = this.getNbf();
        String other$nbf = other.getNbf();
        if (this$nbf == null ? other$nbf != null : !this$nbf.equals(other$nbf)) {
            return false;
        }
        String this$iat = this.getIat();
        String other$iat = other.getIat();
        if (this$iat == null ? other$iat != null : !this$iat.equals(other$iat)) {
            return false;
        }
        String this$jti = this.getJti();
        String other$jti = other.getJti();
        return !(this$jti == null ? other$jti != null : !this$jti.equals(other$jti));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Jwt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alg = this.getAlg();
        result = result * 59 + ($alg == null ? 43 : $alg.hashCode());
        String $typ = this.getTyp();
        result = result * 59 + ($typ == null ? 43 : $typ.hashCode());
        String $iss = this.getIss();
        result = result * 59 + ($iss == null ? 43 : $iss.hashCode());
        String $exp = this.getExp();
        result = result * 59 + ($exp == null ? 43 : $exp.hashCode());
        String $sub = this.getSub();
        result = result * 59 + ($sub == null ? 43 : $sub.hashCode());
        String $aud = this.getAud();
        result = result * 59 + ($aud == null ? 43 : $aud.hashCode());
        String $nbf = this.getNbf();
        result = result * 59 + ($nbf == null ? 43 : $nbf.hashCode());
        String $iat = this.getIat();
        result = result * 59 + ($iat == null ? 43 : $iat.hashCode());
        String $jti = this.getJti();
        result = result * 59 + ($jti == null ? 43 : $jti.hashCode());
        return result;
    }

    public String toString() {
        return "Jwt(alg=" + this.getAlg() + ", typ=" + this.getTyp() + ", iss=" + this.getIss() + ", exp=" + this.getExp() + ", sub=" + this.getSub() + ", aud=" + this.getAud() + ", nbf=" + this.getNbf() + ", iat=" + this.getIat() + ", jti=" + this.getJti() + ")";
    }

    public Jwt() {
    }

    public Jwt(String alg, String typ, String iss, String exp, String sub, String aud, String nbf, String iat, String jti) {
        this.alg = alg;
        this.typ = typ;
        this.iss = iss;
        this.exp = exp;
        this.sub = sub;
        this.aud = aud;
        this.nbf = nbf;
        this.iat = iat;
        this.jti = jti;
    }
}

