/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.exception.web.enumeration;

import com.kevinkda.core.util.exception.web.ErrorMessages;

public enum ErrorCode implements ErrorMessages
{
    SUCCESS(0, "SUCCESS"),
    FAILED(1, "FAILED"),
    UNKNOWN_ERROR(10000, "unknown error"),
    NULL_CALLBACK(10001, "Specified parameter not passed in: callback"),
    NOT_IMPL(10002, "Function not implemented, access forbidden"),
    SERVER_ERR(10003, "Server internal error, stop access"),
    NULL_PARAMETERS(10004, "No parameters specified in the business logic were passed in"),
    NULL_USERNAME(10005, "Specified parameter not passed in: userAcc"),
    NULL_USER_PASS(10006, "Specified parameter not passed in: userPass"),
    NULL_USER_TYPE(10007, "Specified parameter not passed in: userType"),
    DB_INSERT_ERR(10100, "Database insertion error, access execution denied"),
    DB_INSERT_PART_ERR(10101, "Database partial data insertion error, access execution allowed"),
    DENIED_GET_REQUEST(10200, "User request type is get, denial of service"),
    REGEX_USER_ACC_ERR(10300, "Regular validation error: userAcc"),
    REGEX_USER_PASS_ERR(10301, "Regular validation error: userPass"),
    JWT_ILLEGAL(10400, "JWT illegal"),
    USER_ACC_NOT_EXIST(20000, "user name does not exist"),
    USER_PASS_ERROR(20001, "Wrong user name or password"),
    USER_TYPE_ERROR(20002, "Wrong user type"),
    USER_NAME_EXISTS(20003, "User name exists"),
    EMAIL_EXISTS(20004, "Email address exists"),
    USER_ACCESS_DENIED(20100, "Access denied by current user"),
    RISK_ABNORMAL_LOGIN(20101, "User has abnormal login risk"),
    RISK_NORMAL_LOGIN(20102, "Normal login without abnormal risk"),
    TEST(70000, "Dev Test");

    private int code;
    private String msg;

    private ErrorCode() {
    }

    private ErrorCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public String toString() {
        return "ErrorCode{code=" + this.code + ", msg='" + this.msg + '\'' + '}';
    }
}

