/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.lock;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.klock.lock.Lock;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;

public class WriteLock
implements Lock {
    private RReadWriteLock rLock;
    private final LockInfo lockInfo;
    private RedissonClient redissonClient;

    public WriteLock(RedissonClient redissonClient, LockInfo info) {
        this.redissonClient = redissonClient;
        this.lockInfo = info;
    }

    @Override
    public boolean acquire() {
        try {
            this.rLock = this.redissonClient.getReadWriteLock(this.lockInfo.getName());
            return this.rLock.writeLock().tryLock(this.lockInfo.getWaitTime(), this.lockInfo.getLeaseTime(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void release() {
        if (this.rLock.writeLock().isHeldByCurrentThread()) {
            this.rLock.writeLock().unlockAsync();
        }
    }
}

