/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.lock;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.klock.lock.Lock;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;

public class ReentrantLock
implements Lock {
    private RLock rLock;
    private final LockInfo lockInfo;
    private RedissonClient redissonClient;

    public ReentrantLock(RedissonClient redissonClient, LockInfo lockInfo) {
        this.redissonClient = redissonClient;
        this.lockInfo = lockInfo;
    }

    @Override
    public boolean acquire() {
        try {
            this.rLock = this.redissonClient.getLock(this.lockInfo.getName());
            return this.rLock.tryLock(this.lockInfo.getWaitTime(), this.lockInfo.getLeaseTime(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void release() {
        if (this.rLock.isHeldByCurrentThread()) {
            this.rLock.unlockAsync();
        }
    }

    public String getKey() {
        return this.lockInfo.getName();
    }
}

