/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.lock;

import org.aspectj.lang.ProceedingJoinPoint;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.boot.autoconfigure.klock.core.LockInfoProvider;
import org.springframework.boot.autoconfigure.klock.lock.FairLock;
import org.springframework.boot.autoconfigure.klock.lock.Lock;
import org.springframework.boot.autoconfigure.klock.lock.ReadLock;
import org.springframework.boot.autoconfigure.klock.lock.ReentrantLock;
import org.springframework.boot.autoconfigure.klock.lock.WriteLock;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;

public class LockFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private LockInfoProvider lockInfoProvider;

    public Lock getLock(ProceedingJoinPoint joinPoint, Klock klock) {
        LockInfo lockInfo = this.lockInfoProvider.get(joinPoint, klock);
        switch (lockInfo.getType()) {
            case Reentrant: {
                return new ReentrantLock(this.redissonClient, lockInfo);
            }
            case Fair: {
                return new FairLock(this.redissonClient, lockInfo);
            }
            case Read: {
                return new ReadLock(this.redissonClient, lockInfo);
            }
            case Write: {
                return new WriteLock(this.redissonClient, lockInfo);
            }
        }
        return new ReentrantLock(this.redissonClient, lockInfo);
    }
}

