/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.core;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.boot.autoconfigure.klock.config.KlockConfig;
import org.springframework.boot.autoconfigure.klock.core.BusinessKeyProvider;
import org.springframework.boot.autoconfigure.klock.model.LockInfo;
import org.springframework.boot.autoconfigure.klock.model.LockType;

public class LockInfoProvider {
    public static final String LOCK_NAME_PREFIX = "lock";
    public static final String LOCK_NAME_SEPARATOR = ".";
    @Autowired
    private KlockConfig klockConfig;
    @Autowired
    private BusinessKeyProvider businessKeyProvider;

    public LockInfo get(ProceedingJoinPoint joinPoint, Klock klock) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        LockType type = klock.lockType();
        String businessKeyName = this.businessKeyProvider.getKeyName(joinPoint, klock);
        String lockName = "lock." + this.getName(klock.name(), signature) + businessKeyName;
        long waitTime = this.getWaitTime(klock);
        long leaseTime = this.getLeaseTime(klock);
        return new LockInfo(type, lockName, waitTime, leaseTime);
    }

    private String getName(String annotationName, MethodSignature signature) {
        if (annotationName.isEmpty()) {
            return String.format("%s.%s", signature.getDeclaringTypeName(), signature.getMethod().getName());
        }
        return annotationName;
    }

    private long getWaitTime(Klock lock) {
        return lock.waitTime() == Long.MIN_VALUE ? this.klockConfig.getWaitTime() : lock.waitTime();
    }

    private long getLeaseTime(Klock lock) {
        return lock.leaseTime() == Long.MIN_VALUE ? this.klockConfig.getLeaseTime() : lock.leaseTime();
    }
}

