/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.klock.core;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.boot.autoconfigure.klock.lock.Lock;
import org.springframework.boot.autoconfigure.klock.lock.LockFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=0)
public class KlockAspectHandler {
    @Autowired
    LockFactory lockFactory;
    private ThreadLocal<Lock> currentThreadLock = new ThreadLocal();
    private ThreadLocal<Boolean> currentThreadLockRes = new ThreadLocal();

    @Around(value="@annotation(klock)")
    public Object around(ProceedingJoinPoint joinPoint, Klock klock) throws Throwable {
        this.currentThreadLockRes.set(false);
        Lock lock = this.lockFactory.getLock(joinPoint, klock);
        boolean lockRes = lock.acquire();
        this.currentThreadLock.set(lock);
        this.currentThreadLockRes.set(lockRes);
        return joinPoint.proceed();
    }

    @AfterReturning(value="@annotation(klock)")
    public void afterReturning(Klock klock) {
        if (this.currentThreadLockRes.get().booleanValue()) {
            this.currentThreadLock.get().release();
        }
    }

    @AfterThrowing(value="@annotation(klock)")
    public void afterThrowing(Klock klock) {
        if (this.currentThreadLockRes.get().booleanValue()) {
            this.currentThreadLock.get().release();
        }
    }
}

