/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class Timer {
    private final Queue queue = new Queue();
    private final Thread thread = new Thread(this::loop, "SSK-Timer");
    private static final Timer instance = new Timer();

    private Timer() {
        this.thread.setDaemon(true);
        this.thread.setPriority(10);
        this.thread.start();
    }

    private void loop() {
        try {
            while (true) {
                Task task = this.queue.get();
                task.run();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static long currentTime() {
        return System.nanoTime() / 1000000L;
    }

    public static Task add(Runnable runnable) {
        return Timer.add(null, runnable);
    }

    public static Task add(long delay, Runnable runnable) {
        return Timer.add(delay, null, runnable);
    }

    public static Task add(Executor executor, Runnable runnable) {
        return Timer.add(0L, executor, runnable);
    }

    public static Task add(long delay, Executor executor, Runnable runnable) {
        Task task = new Task(Timer.currentTime() + delay, runnable, executor);
        Timer.instance.queue.addTask(task);
        return task;
    }

    public static TaskBuilder builder(Runnable runnable) {
        return new TaskBuilder(runnable);
    }

    private static class Queue {
        Task head;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition notEmpty = this.lock.newCondition();

        private Queue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTask(Task task) {
            if (task.runnable == null || task.isCancel || task.count.get() == 0) {
                return;
            }
            this.lock.lock();
            try {
                if (this.head == null) {
                    this.head = task;
                    this.notEmpty.signal();
                    return;
                }
                if (task.when < this.head.when) {
                    task.next = this.head;
                    this.head = task;
                    this.notEmpty.signal();
                    return;
                }
                Task pre = this.head;
                while (pre.next != null && pre.next.when < task.when) {
                    pre = pre.next;
                }
                Task temp = pre.next;
                pre.next = task;
                task.next = temp;
                this.notEmpty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        Task get() throws InterruptedException {
            this.lock.lock();
            try {
                if (this.head == null) {
                    this.notEmpty.await();
                }
                if (!this.head.isExpired()) {
                    this.notEmpty.await(this.head.remaining(), TimeUnit.MILLISECONDS);
                    Task task = this.get();
                    return task;
                }
                Task task = this.head;
                this.head = this.head.next;
                Task task2 = task;
                return task2;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static class TaskBuilder {
        private final Runnable runnable;
        private Executor executor;
        private long delay;
        private long period;
        private int count = 1;

        public TaskBuilder(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException("runnable can not be null");
            }
            this.runnable = runnable;
        }

        public TaskBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public TaskBuilder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public TaskBuilder period(long period, int count) {
            if (period < 20L) {
                throw new IllegalArgumentException("period cannot be less than 20");
            }
            if (count == 0) {
                throw new IllegalArgumentException("count cannot be equals 0");
            }
            this.period = period;
            this.count = count;
            return this;
        }

        public TaskBuilder period(long period) {
            return this.period(period, -1);
        }

        public Task start() {
            Task task = new Task(this);
            instance.queue.addTask(task);
            return task;
        }
    }

    public static class Task {
        private long when;
        private volatile boolean isCancel;
        private final Runnable runnable;
        private final Executor executor;
        private final long period;
        private final AtomicInteger count;
        private Task next;

        private Task(TaskBuilder builder) {
            this.runnable = builder.runnable;
            this.when = Timer.currentTime() + builder.delay;
            this.period = builder.period;
            this.count = new AtomicInteger(builder.count);
            this.executor = builder.executor;
        }

        private Task(long when, Runnable runnable, Executor executor) {
            this.when = when;
            this.runnable = runnable;
            this.executor = executor;
            this.period = 0L;
            this.count = new AtomicInteger(1);
        }

        boolean isExpired() {
            return Timer.currentTime() >= this.when;
        }

        long remaining() {
            return this.when - Timer.currentTime();
        }

        public void cancel() {
            this.isCancel = true;
        }

        void run() {
            if (this.isCancel) {
                return;
            }
            if (this.executor == null) {
                this.realRun();
            } else {
                this.executor.execute(this::realRun);
            }
        }

        void realRun() {
            if (this.isCancel) {
                return;
            }
            try {
                this.runnable.run();
            }
            catch (Exception exception) {
            }
            finally {
                if (this.count.decrementAndGet() != 0) {
                    this.when += this.period;
                    instance.queue.addTask(this);
                }
            }
        }
    }
}

