/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadUtils {
    private static final Map<Integer, Map<Integer, ExecutorService>> TYPE_PRIORITY_POOL = new HashMap<Integer, Map<Integer, ExecutorService>>();
    private static final int PRIORITY_SINGLE = 8;
    private static final int PRIORITY_CPU = 7;
    private static final int PRIORITY_IO = 5;
    private static final int PRIORITY_CACHED = 4;
    private static final byte TYPE_SINGLE = -1;
    private static final byte TYPE_CACHED = -2;
    private static final byte TYPE_IO = -4;
    private static final byte TYPE_CPU = -8;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();

    public static ExecutorService createFixed(int count) {
        return ThreadUtils.createPoolByTypeAndPriority(count, 5);
    }

    public static ExecutorService getSinglePool() {
        return ThreadUtils.getSinglePool(8);
    }

    public static ExecutorService getSinglePool(int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-1, priority);
    }

    public static ExecutorService getCachedPool() {
        return ThreadUtils.getCachedPool(4);
    }

    public static ExecutorService getCachedPool(int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-2, priority);
    }

    public static ExecutorService getIOPool() {
        return ThreadUtils.getIOPool(5);
    }

    public static ExecutorService getIOPool(int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-4, priority);
    }

    public static ExecutorService getCPUPool() {
        return ThreadUtils.getCPUPool(7);
    }

    public static ExecutorService getCPUPool(int priority) {
        return ThreadUtils.getPoolByTypeAndPriority(-8, priority);
    }

    private static synchronized ExecutorService getPoolByTypeAndPriority(int type, int priority) {
        ExecutorService pool;
        Map<Integer, ExecutorService> serviceMap = TYPE_PRIORITY_POOL.get(type);
        if (serviceMap == null) {
            serviceMap = new HashMap<Integer, ExecutorService>();
            TYPE_PRIORITY_POOL.put(type, serviceMap);
        }
        if ((pool = serviceMap.get(priority)) == null) {
            pool = ThreadUtils.createPoolByTypeAndPriority(type, priority);
            serviceMap.put(priority, pool);
        }
        return pool;
    }

    private static ExecutorService createPoolByTypeAndPriority(int type, int priority) {
        switch (type) {
            case -1: {
                return Executors.newSingleThreadExecutor(new UtilsThreadFactory("single", priority));
            }
            case -2: {
                return new ThreadPoolExecutor(1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new UtilsThreadFactory("cached", priority));
            }
            case -4: {
                return new ThreadPoolExecutor(2 * CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new UtilsThreadFactory("io", priority));
            }
            case -8: {
                return new ThreadPoolExecutor(CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new UtilsThreadFactory("cpu", priority));
            }
        }
        return Executors.newFixedThreadPool(type, new UtilsThreadFactory("fixed(" + type + ")", priority));
    }

    private static final class UtilsThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final AtomicInteger threadId = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;

        UtilsThreadFactory(String prefix, int priority) {
            this.namePrefix = prefix + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.threadId.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            t.setPriority(this.priority);
            return t;
        }
    }
}

