/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.Pair;
import cn.keayuan.util.function.BiConsumer;
import cn.keayuan.util.function.Consumer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Task<V>
extends FutureTask<V> {
    private final Pair<BiConsumer<Task<V>, V>, Executor> success;
    private final Pair<BiConsumer<Task<V>, Throwable>, Executor> error;
    private final Pair<Consumer<Task<V>>, Executor> cancel;
    private final Consumer<Task<V>> complete;
    private final String tag;
    private volatile boolean timeout;

    private Task(Builder<V> builder) {
        super(((Builder)builder).callable);
        this.success = ((Builder)builder).success;
        this.error = ((Builder)builder).error;
        this.cancel = ((Builder)builder).cancel;
        this.complete = ((Builder)builder).complete;
        this.tag = ((Builder)builder).tag;
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.callback(this.cancel, null, null, true);
            return;
        }
        if (this.timeout) {
            return;
        }
        try {
            Object v = this.get();
            this.callback(this.success, v, null, false);
        }
        catch (InterruptedException | ExecutionException e) {
            this.callback(this.error, null, e, false);
        }
    }

    private void get(long timeout) {
        try {
            this.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException | ExecutionException e) {
            this.cancel();
        }
        catch (TimeoutException e) {
            this.timeout = true;
            this.callback(this.error, null, e, false);
        }
    }

    private void onCancel() {
        if (this.cancel != null && this.cancel.first != null) {
            ((Consumer)this.cancel.first).accept((Object)this);
        }
        this.onComplete();
    }

    private void onSuccess(V v) {
        if (this.success != null && this.success.first != null) {
            ((BiConsumer)this.success.first).accept((Object)this, v);
        }
        this.onComplete();
    }

    private void onError(Throwable t) {
        if (this.error != null && this.error.first != null) {
            ((BiConsumer)this.error.first).accept((Object)this, (Object)t);
        }
        this.onComplete();
    }

    private void callback(Pair<?, Executor> pair, V v, Throwable e, boolean cancel) {
        if (pair == null || pair.second == null) {
            if (cancel) {
                this.onCancel();
            } else if (e != null) {
                this.onError(e);
            } else {
                this.onSuccess(v);
            }
        } else {
            ((Executor)pair.second).execute(() -> this.callback(null, v, e, cancel));
        }
    }

    private void onComplete() {
        if (this.complete != null) {
            this.complete.accept((Object)this);
        }
    }

    public boolean cancel() {
        return super.cancel(true);
    }

    public String getTag() {
        return this.tag;
    }

    public static <V> Builder<V> builder(Callable<V> callable) {
        return new Builder<V>(callable);
    }

    public static final class Builder<V> {
        private Pair<BiConsumer<Task<V>, V>, Executor> success;
        private Pair<BiConsumer<Task<V>, Throwable>, Executor> error;
        private Pair<Consumer<Task<V>>, Executor> cancel;
        private Consumer<Task<V>> complete;
        private final Callable<V> callable;
        private String tag;

        public Builder(Callable<V> callable) {
            this.callable = callable;
        }

        public Builder<V> tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder<V> success(BiConsumer<Task<V>, V> consumer) {
            return this.success(null, consumer);
        }

        public Builder<V> success(Executor executor, BiConsumer<Task<V>, V> consumer) {
            this.success = Pair.create(consumer, executor);
            return this;
        }

        public Builder<V> error(BiConsumer<Task<V>, Throwable> consumer) {
            return this.error(null, consumer);
        }

        public Builder<V> error(Executor executor, BiConsumer<Task<V>, Throwable> consumer) {
            this.error = Pair.create(consumer, executor);
            return this;
        }

        public Builder<V> cancel(Consumer<Task<V>> consumer) {
            return this.cancel(null, consumer);
        }

        public Builder<V> cancel(Executor executor, Consumer<Task<V>> consumer) {
            this.cancel = Pair.create(consumer, executor);
            return this;
        }

        public Builder<V> complete(Consumer<Task<V>> consumer) {
            this.complete = consumer;
            return this;
        }

        public Task<V> submit(Executor executor, long timeout) {
            Task task = new Task(this);
            executor.execute(task);
            executor.execute(() -> task.get(timeout));
            return task;
        }

        public Task<V> submit(Executor executor) {
            Task task = new Task(this);
            executor.execute(task);
            return task;
        }
    }
}

