/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.ObjectUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;

public class StringUtils {
    public static final String NULL = "null";

    private StringUtils() {
        throw new AssertionError();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean notEmpty(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static String emptyIfNull(String str, String def) {
        return str == null ? StringUtils.emptyIfNull(def) : str;
    }

    public static String emptyIfNull(String str) {
        return str == null ? "" : str;
    }

    public static String join(CharSequence delimiter, Object ... obj) {
        StringBuilder builder = new StringBuilder();
        for (Object s : obj) {
            builder.append(s).append(delimiter);
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - delimiter.length());
        }
        return builder.toString();
    }

    public static String join(CharSequence delimiter, Iterable<?> tokens) {
        Iterator<?> it = tokens.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter);
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static boolean equals(String actual, String expected) {
        return ObjectUtils.equals(actual, expected);
    }

    public static int length(CharSequence str) {
        return str == null ? 0 : str.length();
    }

    public static String capitalizeFirstLetter(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char c = str.charAt(0);
        return !Character.isLetter(c) || Character.isUpperCase(c) ? str : Character.toUpperCase(c) + str.substring(1);
    }

    public static String utf8Encode(String str) {
        if (!StringUtils.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UnsupportedEncodingException occurred. ", e);
            }
        }
        return str;
    }

    public static String utf8Encode(String str, String def) {
        if (!StringUtils.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return def;
            }
        }
        return str;
    }

    public static String htmlEscapeCharsToString(String source) {
        return StringUtils.isEmpty(source) ? source : source.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("&quot;", "\"");
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return NULL;
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return t.toString();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String valueOf(Object obj) {
        StringBuilder builder = new StringBuilder();
        StringUtils.objToString(builder, obj);
        return builder.toString();
    }

    private static void objToString(StringBuilder builder, Object obj) {
        if (builder == null) {
            return;
        }
        if (obj == null) {
            builder.append(NULL);
        } else if (obj instanceof Throwable) {
            builder.append('\n');
            builder.append(StringUtils.getStackTraceString((Throwable)obj));
        } else if (obj.getClass().isArray()) {
            builder.append('[');
            if (Array.getLength(obj) > 0) {
                StringUtils.arrayString(builder, obj);
                builder.setLength(builder.length() - 1);
            }
            builder.append(']');
        } else if (obj instanceof String) {
            builder.append((String)obj);
        } else {
            builder.append(obj);
        }
    }

    private static void arrayString(StringBuilder builder, Object obj) {
        if (obj instanceof boolean[]) {
            StringUtils.boolString(builder, (boolean[])obj);
            Arrays.toString((boolean[])obj);
        } else if (obj instanceof byte[]) {
            StringUtils.byteString(builder, (byte[])obj);
        } else if (obj instanceof char[]) {
            StringUtils.charString(builder, (char[])obj);
        } else if (obj instanceof short[]) {
            StringUtils.shortString(builder, (short[])obj);
        } else if (obj instanceof int[]) {
            StringUtils.intString(builder, (int[])obj);
        } else if (obj instanceof float[]) {
            StringUtils.floatString(builder, (float[])obj);
        } else if (obj instanceof long[]) {
            StringUtils.longString(builder, (long[])obj);
        } else if (obj instanceof double[]) {
            StringUtils.doubleString(builder, (double[])obj);
        } else {
            StringUtils.objectString(builder, (Object[])obj);
        }
    }

    private static void boolString(StringBuilder builder, boolean[] value) {
        for (boolean b : value) {
            builder.append(b).append(',');
        }
    }

    private static void byteString(StringBuilder builder, byte[] value) {
        for (byte b : value) {
            builder.append(Integer.toHexString(b & 0xFF)).append(',');
        }
    }

    private static void charString(StringBuilder builder, char[] value) {
        for (char b : value) {
            builder.append(b).append(',');
        }
    }

    private static void shortString(StringBuilder builder, short[] value) {
        for (short b : value) {
            builder.append(b).append(',');
        }
    }

    private static void intString(StringBuilder builder, int[] value) {
        for (int b : value) {
            builder.append(b).append(',');
        }
    }

    private static void floatString(StringBuilder builder, float[] value) {
        for (float b : value) {
            builder.append(b).append(',');
        }
    }

    private static void longString(StringBuilder builder, long[] value) {
        for (long b : value) {
            builder.append(b).append(',');
        }
    }

    private static void doubleString(StringBuilder builder, double[] value) {
        for (double b : value) {
            builder.append(b).append(',');
        }
    }

    private static void objectString(StringBuilder builder, Object[] value) {
        for (Object b : value) {
            StringUtils.objToString(builder, b);
            builder.append(',');
        }
    }
}

