/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import android.os.Handler;
import android.os.Looper;
import cn.keayuan.util.ThreadUtils;
import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.Logger;
import java.util.concurrent.Executor;

public final class Platform {
    private static ILog log;
    private static final IPlatform PLATFORM;
    public static final boolean isAndroid;

    Platform() {
    }

    public static void setLogger(ILog iLog) {
        log = iLog;
    }

    public static ILog logger() {
        return log == null ? Logger.getLog() : log;
    }

    public static void runIO(Runnable run) {
        PLATFORM.runIO(run);
    }

    public static void runMain(Runnable run) {
        PLATFORM.runMain(run);
    }

    public static boolean isMainThread() {
        return PLATFORM.isMainThread();
    }

    public static Executor getMainExecutor() {
        return PLATFORM.getMainExecutor();
    }

    static {
        boolean is = false;
        try {
            if (Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null) > 0) {
                is = true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        isAndroid = is;
        PLATFORM = isAndroid ? new PlatformAndroid() : new IPlatform();
    }

    private static class PlatformAndroid
    extends IPlatform {
        private final Handler mainHandler;
        private final Executor mainExecutor = new Executor(){

            @Override
            public void execute(Runnable command) {
                mainHandler.post(command);
            }
        };

        PlatformAndroid() {
            this.mainHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        void runMain(Runnable runnable) {
            this.mainHandler.post(runnable);
        }

        @Override
        boolean isMainThread() {
            return Looper.getMainLooper() == Looper.myLooper();
        }

        @Override
        Executor getMainExecutor() {
            return this.mainExecutor;
        }
    }

    private static class IPlatform {
        private IPlatform() {
        }

        void runIO(Runnable run) {
            ThreadUtils.getIOPool().execute(run);
        }

        void runMain(Runnable run) {
            this.getMainExecutor().execute(run);
        }

        boolean isMainThread() {
            return true;
        }

        Executor getMainExecutor() {
            return ThreadUtils.getCPUPool();
        }
    }
}

