/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.OptionalJSON;
import cn.keayuan.util.Platform;
import cn.keayuan.util.function.Consumer;
import org.json.JSONArray;
import org.json.JSONException;

public class OptionalJSONArray {
    private static final String TAG = "OptionalJSONArray";
    private static final OptionalJSONArray EMPTY = new OptionalJSONArray(null);
    private final JSONArray value;

    private OptionalJSONArray(JSONArray arr) {
        this.value = arr;
    }

    public static OptionalJSONArray of(JSONArray arr) {
        return arr == null ? EMPTY : new OptionalJSONArray(arr);
    }

    public static OptionalJSONArray of(String content) {
        return OptionalJSONArray.of(OptionalJSONArray.parse(content));
    }

    private static JSONArray parse(String content) {
        if (content != null) {
            try {
                return new JSONArray(content);
            }
            catch (JSONException e) {
                Platform.logger().e(TAG, new Object[]{"parse error", e});
            }
        }
        return null;
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public int optInt(int index, int def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optInt(index, def);
    }

    public boolean optBoolean(int index, boolean def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optBoolean(index, def);
    }

    public long optLong(int index, long def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optLong(index, def);
    }

    public double optDouble(int index) {
        return this.optDouble(index, 0.0);
    }

    public double optDouble(int index, double def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optDouble(index, def);
    }

    public String optString(int index, String def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optString(index, def);
    }

    public OptionalJSON optObject(int index) {
        return OptionalJSON.of(this.value == null ? null : this.value.optJSONObject(index));
    }

    public OptionalJSONArray optArray(int index) {
        return OptionalJSONArray.of(this.value == null ? null : this.value.optJSONArray(index));
    }

    public <T> void forEach(Consumer<T> consumer) {
        if (this.value == null || consumer == null) {
            return;
        }
        int len = this.value.length();
        for (int i = 0; i < len; ++i) {
            consumer.accept(this.value.opt(i));
        }
    }

    public JSONArray get() {
        return this.value;
    }
}

