/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.function.BiConsumer;
import cn.keayuan.util.function.Consumer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class IOUtils {
    private IOUtils() {
        throw new AssertionError();
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new RuntimeException("IOException occurred. ", e);
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                try {
                    if (closeable == null) continue;
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean transformQuietly(InputStream is, OutputStream os, boolean autoClose) {
        try {
            IOUtils.transform(is, os, autoClose);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transform(InputStream is, OutputStream os, boolean autoClose) throws IOException {
        try {
            int length;
            byte[] data = new byte[10240];
            while ((length = is.read(data)) != -1) {
                os.write(data, 0, length);
            }
            os.flush();
            if (!autoClose) return;
        }
        catch (Throwable throwable) {
            if (!autoClose) throw throwable;
            IOUtils.closeQuietly(is, os);
            throw throwable;
        }
        IOUtils.closeQuietly(is, os);
    }

    public static void read(InputStream is, BiConsumer<byte[], Integer> consumer) throws IOException {
        int length;
        byte[] data = new byte[10240];
        while ((length = is.read(data)) != -1) {
            consumer.accept((Object)data, (Object)length);
        }
    }

    public static byte[] read(InputStream is, boolean autoClose) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.transform(is, os, autoClose);
        return os.toByteArray();
    }

    public static String readToString(InputStream is, String charset, boolean autoClose) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.transform(is, os, autoClose);
        return charset == null ? os.toString() : os.toString(charset);
    }

    public static void readLine(InputStream is, String charset, Consumer<String> consumer) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
        while ((line = reader.readLine()) != null) {
            consumer.accept((Object)line);
        }
    }
}

