/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.IOUtils;
import cn.keayuan.util.Platform;
import cn.keayuan.util.StringUtils;
import cn.keayuan.util.function.Consumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    private static final String TAG = "FileUtils";
    private static final String FILE_EXTENSION_SEPARATOR = ".";

    private FileUtils() {
        throw new AssertionError();
    }

    public static String toKB(long size, int exactness) {
        double v = (double)size / 1024.0;
        return String.format("%." + exactness + "fKB", v);
    }

    public static String toMB(long size, int exactness) {
        double v = (double)size / 1024.0 / 1024.0;
        return String.format("%." + exactness + "fMB", v);
    }

    public static String toGB(long size, int exactness) {
        double v = (double)size / 1024.0 / 1024.0 / 1024.0;
        return String.format("%." + exactness + "fGB", v);
    }

    public static String toTB(long size, int exactness) {
        double v = (double)size / 1024.0 / 1024.0 / 1024.0 / 1024.0;
        return String.format("%." + exactness + "fTB", v);
    }

    public static byte[] readFile(String filePath) throws IOException {
        if (!FileUtils.isFileExist(filePath)) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(filePath);){
            byte[] byArray = IOUtils.read((InputStream)is, true);
            return byArray;
        }
    }

    public static boolean writeFile(String filePath, byte[] data) {
        boolean bl;
        if (StringUtils.isEmpty(filePath)) {
            return false;
        }
        FileUtils.makeDirs(filePath);
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (!file.createNewFile()) {
            Platform.logger().e(TAG, new Object[]{"create new file failed"});
            return false;
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            os.write(data);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Platform.logger().e(TAG, new Object[]{"write file failed"});
                return false;
            }
        }
        os.close();
        return bl;
    }

    public static boolean writeFile(String filePath, String content, boolean append) {
        boolean bl;
        if (StringUtils.isEmpty(content)) {
            Platform.logger().w(TAG, new Object[]{"write file content is empty"});
            return false;
        }
        FileWriter fileWriter = new FileWriter(filePath, append);
        try {
            FileUtils.makeDirs(filePath);
            fileWriter.write(content);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Platform.logger().e(TAG, new Object[]{"write file failed", e});
                return false;
            }
        }
        fileWriter.close();
        return bl;
    }

    public static boolean writeFile(String filePath, String content) {
        return FileUtils.writeFile(filePath, content, false);
    }

    public static boolean writeFile(String filePath, InputStream stream) {
        return FileUtils.writeFile(filePath, stream, false);
    }

    public static boolean writeFile(String filePath, InputStream stream, boolean append) {
        return FileUtils.writeFile(new File(filePath != null ? filePath : ""), stream, append);
    }

    public static boolean writeFile(File file, InputStream stream) {
        return FileUtils.writeFile(file, stream, false);
    }

    public static boolean writeFile(File file, InputStream stream, boolean append) {
        boolean bl;
        if (!FileUtils.makeDirs(file.getAbsolutePath())) {
            return false;
        }
        FileOutputStream o = new FileOutputStream(file, append);
        try {
            IOUtils.transform(stream, o, true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)o).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Platform.logger().e(TAG, new Object[]{"write file failed", e});
                return false;
            }
        }
        ((OutputStream)o).close();
        return bl;
    }

    public static boolean moveFile(String sourceFilePath, String destFilePath) {
        if (StringUtils.isEmpty(sourceFilePath) || StringUtils.isEmpty(destFilePath)) {
            return false;
        }
        return FileUtils.moveFile(new File(sourceFilePath), new File(destFilePath));
    }

    public static boolean moveFile(File srcFile, File destFile) {
        boolean rename = srcFile.renameTo(destFile);
        if (!rename && (rename = FileUtils.copyFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath()))) {
            FileUtils.deleteFile(srcFile.getAbsolutePath());
        }
        return rename;
    }

    public static boolean copyFile(String sourceFilePath, String destFilePath) {
        boolean bl;
        FileInputStream inputStream = new FileInputStream(sourceFilePath);
        try {
            bl = FileUtils.writeFile(destFilePath, (InputStream)inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Platform.logger().e(TAG, new Object[]{"copy file error " + sourceFilePath + " to " + destFilePath, e});
                return false;
            }
        }
        ((InputStream)inputStream).close();
        return bl;
    }

    public static List<String> readFileToList(String filePath, String charsetName) {
        ArrayList<String> arrayList;
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (!file.isFile()) {
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        try {
            ArrayList<String> fileContent = new ArrayList<String>();
            IOUtils.readLine(is, charsetName, (Consumer<String>)((Consumer)fileContent::add));
            arrayList = fileContent;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Platform.logger().e(TAG, new Object[]{"read file failed " + filePath, e});
                return null;
            }
        }
        ((InputStream)is).close();
        return arrayList;
    }

    public static String getFileName(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return filePath;
        }
        int filePos = filePath.lastIndexOf(File.separator);
        return filePos == -1 ? filePath : filePath.substring(filePos + 1);
    }

    public static String getFileNameWithoutExtension(String filePath) {
        String fileName = FileUtils.getFileName(filePath);
        if (StringUtils.isEmpty(fileName)) {
            return fileName;
        }
        int exPos = fileName.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        return exPos <= 0 ? fileName : fileName.substring(0, exPos);
    }

    public static String getFolderName(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return filePath;
        }
        int filePos = filePath.lastIndexOf(File.separator);
        return filePos == -1 ? "" : filePath.substring(0, filePos);
    }

    public static String getFileExtension(String filePath) {
        if (StringUtils.isBlank(filePath)) {
            return filePath;
        }
        int extPos = filePath.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        int filePos = filePath.lastIndexOf(File.separator);
        if (extPos == -1 || filePos + 1 >= extPos) {
            return "";
        }
        return filePath.substring(extPos + 1);
    }

    public static boolean makeDirs(String filePath) {
        String folderName = FileUtils.getFolderName(filePath);
        if (StringUtils.isEmpty(folderName)) {
            return false;
        }
        File folder = new File(folderName);
        return folder.exists() && folder.isDirectory() || folder.mkdirs();
    }

    public static boolean isFileExist(String filePath) {
        if (StringUtils.isBlank(filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public static boolean isFolderExist(String directoryPath) {
        if (StringUtils.isBlank(directoryPath)) {
            return false;
        }
        File dire = new File(directoryPath);
        return dire.exists() && dire.isDirectory();
    }

    public static boolean deleteFile(String path) {
        if (StringUtils.isBlank(path)) {
            return true;
        }
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] list = file.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isFile()) {
                    f.delete();
                    continue;
                }
                if (!f.isDirectory()) continue;
                FileUtils.deleteFile(f.getAbsolutePath());
            }
        }
        return file.delete();
    }

    public static long getSize(String path) {
        if (StringUtils.isBlank(path)) {
            return 0L;
        }
        return FileUtils.getSize(new File(path));
    }

    public static long getSize(File file) {
        File[] files;
        if (file == null || !file.exists() || !file.canRead()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        long len = 0L;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                len += FileUtils.getSize(f);
            }
        }
        return len;
    }
}

