/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.Agent;
import cn.keayuan.util.ObjectUtils;
import cn.keayuan.util.function.Consumer;
import cn.keayuan.util.function.Function;
import cn.keayuan.util.function.ObjIntConsumer;
import cn.keayuan.util.function.ObjIntFunction;
import cn.keayuan.util.function.ObjIntPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AgentList<E>
implements Agent<E, List> {
    public final List<E> value;

    @SafeVarargs
    public static <T> AgentList<T> as(T ... ts) {
        return new AgentList<T>(Arrays.asList(ts));
    }

    public static <T> AgentList<T> as(List<T> list) {
        return new AgentList<T>(list);
    }

    public static <T> AgentList<T> empty() {
        return new AgentList(new ArrayList());
    }

    public AgentList(List<E> value) {
        this.value = value;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    @Override
    public int size() {
        return this.isNull() ? 0 : this.value.size();
    }

    @Override
    public boolean isNotEmpty() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public E first() {
        return this.isEmpty() ? null : (E)this.value.get(0);
    }

    @Override
    public E getLast() {
        return this.isEmpty() ? null : (E)this.value.get(this.value.size() - 1);
    }

    public AgentList<E> filter(ObjIntPredicate<E> predicate) {
        ObjectUtils.requireNonNull(predicate);
        if (this.value == null) {
            return this;
        }
        ArrayList ret = new ArrayList();
        this.forEach((e, i) -> {
            if (predicate.test(e, i)) {
                ret.add(e);
            }
        });
        return new AgentList(ret);
    }

    @Override
    public void forEach(Consumer<E> consumer) {
        ObjectUtils.requireNonNull(consumer);
        if (this.isEmpty()) {
            return;
        }
        for (E e : this.value) {
            consumer.accept(e);
        }
    }

    @Override
    public void forEach(boolean reverse, ObjIntConsumer<E> consumer) {
        ObjectUtils.requireNonNull(consumer);
        if (this.isEmpty()) {
            return;
        }
        this.forEachInterruptibly(reverse, (e, i) -> {
            consumer.accept(e, i);
            return false;
        });
    }

    @Override
    public void forEachInterruptibly(boolean reverse, ObjIntPredicate<E> function) {
        ObjectUtils.requireNonNull(function);
        if (this.isEmpty()) {
            return;
        }
        if (reverse) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!function.test(this.value.get(i), i)) continue;
                return;
            }
        } else {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (!function.test(this.value.get(i), i)) continue;
                return;
            }
        }
    }

    public <T> AgentList<T> map(Function<E, T> function) {
        ObjectUtils.requireNonNull(function);
        if (this.isEmpty()) {
            return AgentList.empty();
        }
        ArrayList array = new ArrayList();
        this.forEach(e -> array.add(function.apply(e)));
        return new AgentList(array);
    }

    public <T> AgentList<T> map(ObjIntFunction<E, T> function) {
        ObjectUtils.requireNonNull(function);
        if (this.isEmpty()) {
            return AgentList.empty();
        }
        ArrayList array = new ArrayList();
        this.forEach((e, i) -> array.add(function.apply(e, i)));
        return new AgentList(array);
    }

    @Override
    public List<E> get() {
        return this.value;
    }
}

