/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.ObjectUtils;
import cn.keayuan.util.Wrapper;
import cn.keayuan.util.function.Consumer;
import cn.keayuan.util.function.Function;
import cn.keayuan.util.function.ObjIntConsumer;
import cn.keayuan.util.function.ObjIntFunction;
import cn.keayuan.util.function.ObjIntPredicate;
import cn.keayuan.util.function.Predicate;

public interface Agent<E, C> {
    public boolean isNull();

    public boolean isEmpty();

    public int size();

    public boolean isNotEmpty();

    public E first();

    public E getLast();

    default public boolean anyMatch(Predicate<E> predicate) {
        ObjectUtils.requireNonNull(predicate);
        if (this.isEmpty()) {
            return false;
        }
        Wrapper<Boolean> wrapper = new Wrapper<Boolean>(false);
        this.forEachInterruptibly(e -> {
            if (predicate.test(e)) {
                wrapper.setValue(true);
                return true;
            }
            return false;
        });
        return wrapper.getValue();
    }

    default public boolean allMatch(Predicate<E> predicate) {
        ObjectUtils.requireNonNull(predicate);
        if (this.isEmpty()) {
            return true;
        }
        Wrapper<Boolean> wrapper = new Wrapper<Boolean>(true);
        this.forEachInterruptibly(e -> {
            if (!predicate.test(e)) {
                wrapper.setValue(false);
                return true;
            }
            return false;
        });
        return wrapper.getValue();
    }

    default public Agent<E, C> filter(Predicate<E> predicate) {
        ObjectUtils.requireNonNull(predicate);
        return this.filter((e, i) -> predicate.test(e));
    }

    public Agent<E, C> filter(ObjIntPredicate<E> var1);

    default public int findIndex(Predicate<E> predicate, boolean reverse) {
        ObjectUtils.requireNonNull(predicate);
        if (this.isEmpty()) {
            return -1;
        }
        Wrapper<Integer> wrapper = new Wrapper<Integer>(-1);
        this.forEachInterruptibly(reverse, (e, i) -> {
            if (predicate.test(e)) {
                wrapper.setValue(i);
                return true;
            }
            return false;
        });
        return wrapper.getValue();
    }

    default public int findIndex(Predicate<E> predicate) {
        return this.findIndex(predicate, false);
    }

    default public E find(Predicate<E> predicate) {
        return this.find(predicate, false);
    }

    default public E find(Predicate<E> predicate, boolean reverse) {
        ObjectUtils.requireNonNull(predicate);
        if (this.isEmpty()) {
            return null;
        }
        Wrapper wrapper = new Wrapper(null);
        this.forEachInterruptibly(reverse, (e, i) -> {
            if (predicate.test(e)) {
                wrapper.setValue(e);
                return true;
            }
            return false;
        });
        return (E)wrapper.getValue();
    }

    default public int lastIndex(Predicate<E> predicate) {
        return this.findIndex(predicate, true);
    }

    default public E last(Predicate<E> predicate) {
        return this.find(predicate, true);
    }

    default public void forEach(Consumer<E> consumer) {
        ObjectUtils.requireNonNull(consumer);
        this.forEach(false, (e, i) -> consumer.accept(e));
    }

    default public void forEach(ObjIntConsumer<E> consumer) {
        this.forEach(false, consumer);
    }

    public void forEach(boolean var1, ObjIntConsumer<E> var2);

    default public void forEachInterruptibly(Predicate<E> function) {
        ObjectUtils.requireNonNull(function);
        this.forEachInterruptibly((e, i) -> function.test(e));
    }

    default public void forEachInterruptibly(ObjIntPredicate<E> function) {
        this.forEachInterruptibly(false, function);
    }

    public void forEachInterruptibly(boolean var1, ObjIntPredicate<E> var2);

    public <T> Agent<T, C> map(Function<E, T> var1);

    public <T> Agent<T, C> map(ObjIntFunction<E, T> var1);

    public C get();
}

