/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.StringUtils;
import java.util.ArrayList;

public interface ILog {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;

    default public String getTag() {
        return "default";
    }

    default public void v(String msg, Object ... obj) {
        this.log(2, this.getTag(), msg, obj);
    }

    default public void d(String msg, Object ... obj) {
        this.log(3, this.getTag(), msg, obj);
    }

    default public void i(String msg, Object ... obj) {
        this.log(4, this.getTag(), msg, obj);
    }

    default public void w(String msg, Object ... obj) {
        this.log(5, this.getTag(), msg, obj);
    }

    default public void e(String msg, Object ... obj) {
        this.log(6, this.getTag(), msg, obj);
    }

    default public boolean isLoggable(int level) {
        return true;
    }

    default public void log(int priority, String tag, String msg, Object ... obj) {
        if (!this.isLoggable(priority)) {
            return;
        }
        if (obj.length > 0) {
            ArrayList<String> list = new ArrayList<String>(obj.length);
            for (Object o : obj) {
                list.add(StringUtils.valueOf(o));
            }
            msg = String.format(msg, list.toArray());
        }
        this.log(priority, tag, msg);
    }

    public void log(int var1, String var2, String var3);
}

