/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.flow;

import cn.keayuan.util.flow.FlowProcess;
import cn.keayuan.util.flow.INode;
import cn.keayuan.util.flow.IProcess;

class Node<P, T>
implements INode<P, T>,
Runnable {
    private final String tag;
    private final IProcess<P, T> process;
    private final boolean isMain;
    Node<T, ?> next;
    private Object params;
    private final FlowProcess<?> flowProcess;
    private volatile boolean isCallNext;

    Node(Object arg, FlowProcess<?> fp) {
        this.tag = null;
        this.process = null;
        this.isMain = true;
        this.params = arg;
        this.flowProcess = fp;
    }

    Node(String tag, IProcess<P, T> p, boolean main, FlowProcess<?> fp) {
        this.tag = tag;
        this.process = p;
        this.isMain = main;
        this.flowProcess = fp;
    }

    @Override
    public void run() {
        if (this.flowProcess.isClose) {
            return;
        }
        if (this.process != null) {
            this.process.process(this);
        }
    }

    @Override
    public P getParams() {
        return (P)this.params;
    }

    void setParams(P p) {
        this.params = p;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isMain() {
        return this.isMain;
    }

    @Override
    public void next(String tag, Object t) {
        if (this.isCallNext) {
            throw new IllegalStateException("already call next()");
        }
        this.isCallNext = true;
        this.flowProcess.next(tag, t);
    }

    @Override
    public void next(T t) {
        this.next(null, t);
    }

    @Override
    public void next() {
        this.next(null);
    }

    @Override
    public void close() {
        this.flowProcess.close();
    }

    @Override
    public void remove(String tag) {
        this.flowProcess.remove(tag);
    }
}

