/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.flow;

import cn.keayuan.util.ObjectUtils;
import cn.keayuan.util.Platform;
import cn.keayuan.util.ThreadUtils;
import cn.keayuan.util.flow.IFlow;
import cn.keayuan.util.flow.IProcess;
import cn.keayuan.util.flow.Node;
import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;

public class FlowProcess<P>
implements IFlow<P> {
    private static Executor ioExecutor;
    private static Executor mainExecutor;
    private Node<?, ?> head;
    private Node<?, ?> tail;
    volatile boolean isClose;
    private volatile boolean isStart;
    private final ReentrantLock mLock = new ReentrantLock();

    public static <T> IFlow<T> create(T t) {
        return new FlowProcess<T>(t);
    }

    public static void setMainExecutor(Executor executor) {
        mainExecutor = executor;
    }

    public static void setIOExecutor(Executor executor) {
        ioExecutor = executor;
    }

    private static void execute(Node<?, ?> node) {
        if (node == null) {
            return;
        }
        (node.isMain() ? mainExecutor : ioExecutor).execute(node);
    }

    private FlowProcess(P first) {
        this.head = new Node(first, this);
        this.tail = this.head;
    }

    private <T> IFlow<T> add(String tag, IProcess<P, T> p, boolean main) {
        if (this.isStart) {
            throw new IllegalStateException("process already start, don't add Process.");
        }
        if (p != null) {
            this.mLock.lock();
            this.tail.next = new Node<P, T>(tag, p, main, this);
            this.tail = this.tail.next;
            this.mLock.unlock();
        }
        return this;
    }

    @Override
    public <T> IFlow<T> main(IProcess<P, T> p) {
        return this.main(null, p);
    }

    @Override
    public <T> IFlow<T> main(String tag, IProcess<P, T> p) {
        return this.add(tag, p, true);
    }

    @Override
    public <T> IFlow<T> io(IProcess<P, T> p) {
        return this.io(null, p);
    }

    @Override
    public <T> IFlow<T> io(String tag, IProcess<P, T> p) {
        return this.add(tag, p, false);
    }

    @Override
    public void remove(String tag) {
        this.mLock.lock();
        while (this.head != null && ObjectUtils.equals(tag, this.head.getTag())) {
            this.head = this.head.next;
        }
        if (this.head != null) {
            Node<?, ?> pre = this.head;
            Node<Object, ?> curr = pre.next;
            while (curr != null) {
                if (ObjectUtils.equals(tag, curr.getTag())) {
                    pre.next = curr.next;
                    curr = pre;
                }
                curr = curr.next;
            }
        }
        this.mLock.unlock();
    }

    @Override
    public Closeable start() {
        this.isStart = true;
        this.mLock.lock();
        Object temp = this.head.getParams();
        this.head = this.head.next;
        this.next(null, temp);
        this.mLock.unlock();
        return this;
    }

    void next(String tag, Object arg) {
        if (this.isClose) {
            throw new IllegalStateException("process already close");
        }
        this.mLock.lock();
        if (this.head == null) {
            throw new IllegalStateException("node already end");
        }
        Node<Object, ?> curr = this.head;
        if (tag != null) {
            while (curr != null && !ObjectUtils.equals(tag, curr.getTag())) {
                curr = curr.next;
            }
            if (curr == null) {
                throw new IllegalStateException("tag not exist " + tag);
            }
        }
        this.head = curr.next;
        curr.setParams(arg);
        FlowProcess.execute(curr);
        this.mLock.unlock();
    }

    @Override
    public void close() {
        this.isClose = true;
        this.mLock.lock();
        this.head = null;
        this.mLock.unlock();
    }

    static {
        FlowProcess.setMainExecutor(Platform.getMainExecutor());
        FlowProcess.setIOExecutor(ThreadUtils.getCPUPool());
    }
}

