/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import cn.keayuan.util.function.BiFunction;
import java.lang.ref.WeakReference;

public class ToastUtil {
    private static WeakReference<Toast> toastWeak;
    private static WeakReference<Application> contextWeak;
    private static final Handler mainHandler;
    private static BiFunction<Context, CharSequence, Toast> supplier;

    private ToastUtil() {
    }

    public static void init(Application context) {
        ToastUtil.init(context, null);
    }

    public static void init(Application context, BiFunction<Context, CharSequence, Toast> supplier) {
        contextWeak = new WeakReference<Application>(context);
        ToastUtil.supplier = supplier;
    }

    private static void showToast(Task task) {
        mainHandler.post((Runnable)task);
    }

    public static void show(String content, boolean isLong) {
        ToastUtil.showToast(new Task(content, isLong));
    }

    public static void show(String content) {
        ToastUtil.show(content, false);
    }

    public static void show(Context context, int resId, Object ... args) {
        ToastUtil.show(context, resId, false, args);
    }

    public static void show(Context context, int resId, boolean isLong, Object ... args) {
        ToastUtil.show(context, context.getString(resId, args), isLong);
    }

    public static void show(Context context, String format) {
        ToastUtil.show(context, format, false);
    }

    public static void show(Context context, String format, boolean isLong) {
        ToastUtil.showToast(new Task(context, format, isLong));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel() {
        Class<ToastUtil> clazz = ToastUtil.class;
        synchronized (ToastUtil.class) {
            Toast toast = toastWeak == null ? null : (Toast)toastWeak.get();
            // ** MonitorExit[var1] (shouldn't be in output)
            if (toast != null) {
                toast.cancel();
            }
            return;
        }
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Context context) {
        return new Builder(context);
    }

    static {
        mainHandler = new Handler(Looper.getMainLooper());
    }

    public static class Builder {
        private final Context context;

        private Builder(Context context) {
            if (context == null) {
                throw new NullPointerException();
            }
            this.context = context;
        }

        private Builder() {
            Context context = this.context = contextWeak == null ? null : (Context)contextWeak.get();
            if (this.context == null) {
                throw new NullPointerException();
            }
        }

        void show(String content, Object ... args) {
            ToastUtil.showToast(new Task(String.format(content, args), false));
        }

        void show(int resId, Object ... args) {
            this.show(this.context.getString(resId, args), new Object[0]);
        }

        void showLong(String content, Object ... args) {
            ToastUtil.showToast(new Task(String.format(content, args), true));
        }

        void showLong(int resId, Object ... args) {
            this.showLong(this.context.getString(resId, args), new Object[0]);
        }
    }

    private static class Task
    implements Runnable {
        private final String content;
        private final boolean isLong;
        private final WeakReference<Context> weakContext;

        private Task(String content, boolean isLong) {
            this((Context)contextWeak.get(), content, isLong);
        }

        private Task(Context context, String content, boolean isLong) {
            if (content == null) {
                throw new NullPointerException();
            }
            this.weakContext = new WeakReference<Context>(context);
            this.content = content;
            this.isLong = isLong;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ToastUtil.cancel();
            Context context = (Context)this.weakContext.get();
            if (context == null || this.content == null || context instanceof Activity && ((Activity)context).isFinishing()) {
                return;
            }
            Class<ToastUtil> clazz = ToastUtil.class;
            synchronized (ToastUtil.class) {
                Toast toast;
                if (supplier != null) {
                    toast = (Toast)supplier.apply((Object)context, (Object)this.content);
                } else {
                    toast = new Toast(context);
                    toast.setText((CharSequence)this.content);
                }
                if (toast == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                toast.setDuration(this.isLong ? 1 : 0);
                toast.show();
                toastWeak = new WeakReference<Toast>(toast);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

