/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.Pair;
import cn.keayuan.util.Platform;
import cn.keayuan.util.function.BiConsumer;
import cn.keayuan.util.function.Consumer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;

public final class Task<V>
extends FutureTask<V> {
    private final Pair<BiConsumer<Task<V>, V>, Executor> success;
    private final Pair<BiConsumer<Task<V>, Throwable>, Executor> error;
    private final Pair<Consumer<Task<V>>, Executor> cancel;
    private final Pair<Consumer<Task<V>>, Executor> complete;
    private final String tag;

    private Task(Builder<V> builder) {
        super(((Builder)builder).callable);
        this.success = ((Builder)builder).success;
        this.error = ((Builder)builder).error;
        this.cancel = ((Builder)builder).cancel;
        this.complete = ((Builder)builder).complete;
        this.tag = ((Builder)builder).tag;
    }

    @Override
    protected void done() {
        block6: {
            if (this.isCancelled() && this.checkPair(this.cancel)) {
                ((Executor)this.cancel.second).execute(() -> ((Consumer)this.cancel.first).accept((Object)this));
            } else {
                try {
                    Object v = this.get();
                    if (this.checkPair(this.success)) {
                        ((Executor)this.success.second).execute(() -> ((BiConsumer)this.success.first).accept((Object)this, v));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    if (!this.checkPair(this.error)) break block6;
                    ((Executor)this.error.second).execute(() -> ((BiConsumer)this.error.first).accept((Object)this, (Object)e));
                }
            }
        }
        if (this.checkPair(this.complete)) {
            ((Executor)this.complete.second).execute(() -> ((Consumer)this.complete.first).accept((Object)this));
        }
    }

    private boolean checkPair(Pair<?, ?> pair) {
        return pair != null && pair.first != null && pair.second != null;
    }

    public boolean cancel() {
        return super.cancel(true);
    }

    public String getTag() {
        return this.tag;
    }

    public static final class Builder<V> {
        private Pair<BiConsumer<Task<V>, V>, Executor> success;
        private Pair<BiConsumer<Task<V>, Throwable>, Executor> error;
        private Pair<Consumer<Task<V>>, Executor> cancel;
        private Pair<Consumer<Task<V>>, Executor> complete;
        private final Callable<V> callable;
        private String tag;

        public Builder(Callable<V> callable) {
            this.callable = callable;
        }

        public Builder<V> tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder<V> success(BiConsumer<Task<V>, V> consumer) {
            return this.success(Platform.getMainExecutor(), consumer);
        }

        public Builder<V> success(Executor executor, BiConsumer<Task<V>, V> consumer) {
            this.success = Pair.create(consumer, executor);
            return this;
        }

        public Builder<V> error(BiConsumer<Task<V>, Throwable> consumer) {
            return this.error(Platform.getMainExecutor(), consumer);
        }

        public Builder<V> error(Executor executor, BiConsumer<Task<V>, Throwable> consumer) {
            this.error = Pair.create(consumer, executor);
            return this;
        }

        public Builder<V> cancel(Consumer<Task<V>> consumer) {
            return this.cancel(Platform.getMainExecutor(), consumer);
        }

        public Builder<V> cancel(Executor executor, Consumer<Task<V>> consumer) {
            this.cancel = Pair.create(consumer, executor);
            return this;
        }

        public Builder<V> complete(Consumer<Task<V>> consumer) {
            return this.complete(Platform.getMainExecutor(), consumer);
        }

        public Builder<V> complete(Executor executor, Consumer<Task<V>> consumer) {
            this.complete = Pair.create(consumer, executor);
            return this;
        }

        public Task<V> build() {
            return new Task(this);
        }
    }
}

