/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtil {
    private StatusBarUtil() {
    }

    public static void hideStatusBar(Activity activity) {
        activity.getWindow().addFlags(1024);
        if (Build.VERSION.SDK_INT >= 16) {
            activity.getWindow().getDecorView().setSystemUiVisibility(1028);
            if (Build.VERSION.SDK_INT >= 28) {
                WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
                lp.layoutInDisplayCutoutMode = 1;
                activity.getWindow().setAttributes(lp);
            }
        }
    }

    public static void setTranslucentColor(Activity activity, int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().setStatusBarColor(color);
        } else if (Build.VERSION.SDK_INT >= 19) {
            // empty if block
        }
    }

    public static void setMarginTop(Activity activity, boolean marginStatusBar) {
        if (Build.VERSION.SDK_INT >= 16) {
            int flag = activity.getWindow().getDecorView().getSystemUiVisibility();
            flag = marginStatusBar ? (flag &= 0xFFFFFBFF) : (flag |= 0x400);
            activity.getWindow().getDecorView().setSystemUiVisibility(flag);
        }
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    @TargetApi(value=23)
    public static void setDarkMode(Activity activity, boolean isDark) {
        StatusBarUtil.setMIUIStatusBarDarkIcon(activity, true);
        StatusBarUtil.setMeizuStatusBarDarkIcon(activity, true);
        View decorView = activity.getWindow().getDecorView();
        if (Build.VERSION.SDK_INT >= 23 && decorView != null) {
            int flag = decorView.getSystemUiVisibility();
            flag = isDark ? (flag &= 0xFFFFDFFF) : (flag |= 0x2000);
            decorView.setSystemUiVisibility(flag);
        }
    }

    private static void setMIUIStatusBarDarkIcon(Activity activity, boolean darkIcon) {
        Class<?> clazz = activity.getWindow().getClass();
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), darkIcon ? darkModeFlag : 0, darkModeFlag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setMeizuStatusBarDarkIcon(Activity activity, boolean darkIcon) {
        try {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = darkIcon ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            activity.getWindow().setAttributes(lp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

