/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import android.content.Context;
import android.content.SharedPreferences;

public class SpfUtil {
    private static final String DEFAULT = "spf_default";

    private SpfUtil() {
    }

    public static SharedPreferences get(Context context) {
        return SpfUtil.get(context, DEFAULT);
    }

    public static SharedPreferences get(Context context, String name) {
        return SpfUtil.get(context, name, 0);
    }

    public static SharedPreferences get(Context context, String name, int mode) {
        if (context != null) {
            return context.getSharedPreferences(name, mode);
        }
        return null;
    }

    public static boolean contains(SharedPreferences sp, String key) {
        return SpfUtil.require(sp).contains(key);
    }

    public static void putInt(SharedPreferences sp, String key, int value) {
        SpfUtil.require(sp).edit().putInt(key, value).apply();
    }

    public static int getInt(SharedPreferences sp, String key, int defaultValue) {
        return SpfUtil.require(sp).getInt(key, defaultValue);
    }

    public static int getInt(SharedPreferences sp, String key) {
        return SpfUtil.getInt(sp, key, 0);
    }

    public static void putBoolean(SharedPreferences sp, String key, boolean value) {
        SpfUtil.require(sp).edit().putBoolean(key, value).apply();
    }

    public static boolean getBoolean(SharedPreferences sp, String key) {
        return SpfUtil.getBoolean(sp, key, false);
    }

    public static boolean getBoolean(SharedPreferences sp, String key, boolean defaultValue) {
        return SpfUtil.require(sp).getBoolean(key, defaultValue);
    }

    public static void putString(SharedPreferences sp, String key, String value) {
        SpfUtil.require(sp).edit().putString(key, value == null ? "" : value).apply();
    }

    public static String getString(SharedPreferences sp, String key) {
        return SpfUtil.getString(sp, key, "");
    }

    public static String getString(SharedPreferences sp, String key, String defaultValue) {
        return SpfUtil.require(sp).getString(key, defaultValue);
    }

    public static void putFloat(SharedPreferences sp, String key, float value) {
        SpfUtil.require(sp).edit().putFloat(key, value).apply();
    }

    public static float getFloat(SharedPreferences sp, String key) {
        return SpfUtil.require(sp).getFloat(key, 0.0f);
    }

    public static void putLong(SharedPreferences sp, String key, long value) {
        SpfUtil.require(sp).edit().putLong(key, value).apply();
    }

    public static long getLong(SharedPreferences sp, String key) {
        return SpfUtil.require(sp).getLong(key, 0L);
    }

    public static boolean setValue(SharedPreferences sp, String key, Object value) {
        SpfUtil.require(sp);
        if (key == null || value == null) {
            return false;
        }
        if (value instanceof String) {
            SpfUtil.putString(sp, key, (String)value);
        } else if (value instanceof Integer) {
            SpfUtil.putInt(sp, key, (Integer)value);
        } else if (value instanceof Long) {
            SpfUtil.putLong(sp, key, (Long)value);
        } else if (value instanceof Float) {
            SpfUtil.putFloat(sp, key, ((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            SpfUtil.putBoolean(sp, key, (Boolean)value);
        } else {
            return false;
        }
        return true;
    }

    public static <T> T getValue(SharedPreferences sp, String key, T defaultValue) {
        if (key == null || sp == null) {
            return defaultValue;
        }
        if (defaultValue instanceof String) {
            return (T)SpfUtil.getString(sp, key, (String)defaultValue);
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(SpfUtil.getInt(sp, key));
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(SpfUtil.getLong(sp, key));
        }
        if (defaultValue instanceof Float) {
            return (T)Float.valueOf(SpfUtil.getFloat(sp, key));
        }
        if (defaultValue instanceof Boolean) {
            return (T)Boolean.valueOf(SpfUtil.getBoolean(sp, key));
        }
        return null;
    }

    public static void remove(SharedPreferences sp, String key) {
        SpfUtil.require(sp).edit().remove(key).apply();
    }

    public static void clear(SharedPreferences sp) {
        SpfUtil.require(sp).edit().clear().apply();
    }

    private static <T> T require(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }
}

