/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.PlatformAndroid;
import cn.keayuan.util.PlatformJava;
import cn.keayuan.util.ThreadUtils;
import cn.keayuan.util.function.Function;
import cn.keayuan.util.log.ILog;
import java.util.concurrent.Executor;

public final class Platform {
    private static final IPlatform PLATFORM = Platform.findPlatform();
    private static ILog log;
    private static Function<Integer, Boolean> filter;

    public static IPlatform get() {
        return PLATFORM;
    }

    Platform() {
    }

    private static IPlatform findPlatform() {
        try {
            if (Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null) > 0) {
                return new PlatformAndroid();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return new PlatformJava();
    }

    public static void runIO(Runnable run) {
        PLATFORM.runIO(run);
    }

    public static void runMain(Runnable run) {
        PLATFORM.runMain(run);
    }

    public static void setLogger(ILog iLog) {
        log = iLog;
    }

    public static ILog logger() {
        return log == null ? PLATFORM.logger() : log;
    }

    public static void log(int priority, String tag, String msg, Object ... obj) {
        Boolean pass;
        if (!(filter == null || (pass = (Boolean)filter.apply((Object)priority)) != null && pass.booleanValue())) {
            return;
        }
        PLATFORM.log(priority, tag, msg, obj);
    }

    public static void setLoggerFilter(Function<Integer, Boolean> function) {
        filter = function;
    }

    public static boolean isMainThread() {
        return PLATFORM.isMainThread();
    }

    public static Executor getMainExecutor() {
        return PLATFORM.getMainExecutor();
    }

    public static interface IPlatform
    extends ILog {
        default public void runIO(Runnable run) {
            ThreadUtils.getIOPool().execute(run);
        }

        default public void runMain(Runnable run) {
            this.getMainExecutor().execute(run);
        }

        default public boolean isMainThread() {
            return true;
        }

        default public Executor getMainExecutor() {
            return ThreadUtils.getSinglePool();
        }

        default public ILog logger() {
            return this;
        }

        @Override
        public void log(int var1, String var2, String var3);
    }
}

