/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util;

import cn.keayuan.util.OptionalJSONArray;
import cn.keayuan.util.Platform;
import cn.keayuan.util.function.BiConsumer;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class OptionalJSON {
    private static final String TAG = "OptionalJSON";
    private static final OptionalJSON EMPTY = new OptionalJSON(null);
    private final JSONObject value;

    private OptionalJSON(JSONObject obj) {
        this.value = obj;
    }

    public static OptionalJSON of(String content) {
        return content == null ? EMPTY : OptionalJSON.of(OptionalJSON.parse(content));
    }

    public static OptionalJSON of(JSONObject obj) {
        return obj == null ? EMPTY : new OptionalJSON(obj);
    }

    private static JSONObject parse(String content) {
        if (content != null) {
            try {
                return new JSONObject(content);
            }
            catch (JSONException e) {
                Platform.logger().e(TAG, new Object[]{"parse error", e});
            }
        }
        return null;
    }

    public OptionalJSON optObject(String key) {
        return OptionalJSON.of(this.value == null ? null : this.value.optJSONObject(key));
    }

    public OptionalJSONArray optArray(String key) {
        return OptionalJSONArray.of(this.value == null ? null : this.value.optJSONArray(key));
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optInt(key, def);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optBoolean(key, def);
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optLong(key, def);
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String def) {
        if (this.value == null) {
            return def;
        }
        return this.value.optString(key, def);
    }

    public void forEach(BiConsumer<String, Object> consumer) {
        if (this.value == null || consumer == null) {
            return;
        }
        Iterator keys = this.value.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            consumer.accept((Object)key, this.value.opt(key));
        }
    }

    public JSONObject get() {
        return this.value;
    }
}

