package cn.keayuan.util;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import java.util.concurrent.Executor;

/**
 * Created by keayuan on 2021/9/17.
 *
 * @author keayuan
 */
class PlatformAndroid implements Platform.IPlatform, ILog, Executor {
    private final Handler mainHandler;

    PlatformAndroid() {
        mainHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void runMain(Runnable runnable) {
        mainHandler.post(runnable);
    }

    @Override
    public boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    @Override
    public Executor getMainExecutor() {
        return this;
    }

    @Override
    public ILog logger() {
        return this;
    }

    @Override
    public void log(int priority, String tag, String message) {
        Log.println(priority, tag, message);
    }

    @Override
    public void execute(Runnable command) {
        if (command != null) {
            mainHandler.post(command);
        }
    }
}
