package cn.keayuan.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

/**
 * Created by keayuan on 2021/9/17.
 *
 * @author keayuan
 */
public interface ILog {
    int VERBOSE = 2;
    int DEBUG = 3;
    int INFO = 4;
    int WARN = 5;
    int ERROR = 6;
    int ASSERT = 7;

    default void v(String tag, String msg) {
        log(VERBOSE, tag, msg, null);
    }

    default void d(String tag, String msg) {
        log(DEBUG, tag, msg, null);
    }

    default void i(String tag, String msg) {
        log(INFO, tag, msg, null);
    }

    default void w(String tag, String msg) {
        log(WARN, tag, msg, null);
    }

    default void w(String tag, String msg, Throwable throwable) {
        log(WARN, tag, msg, throwable);
    }

    default void e(String tag, String msg) {
        log(ERROR, tag, msg, null);
    }

    default void e(String tag, String msg, Throwable throwable) {
        log(ERROR, tag, msg + getStackTraceString(throwable));
    }

    default void log(int priority, String tag, String message, Throwable throwable) {
        if (throwable != null) {
            message += '\n' + getStackTraceString(throwable);
        }
        log(priority, tag, message);
    }

    void log(int priority, String tag, String message);

    static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        Throwable t = tr;
        while (t != null) {
            if (t instanceof UnknownHostException) {
                return "";
            }
            t = t.getCause();
        }

        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}
