package cn.keayuan.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import cn.keayuan.util.function.BiConsumer;
import cn.keayuan.util.function.Consumer;

/**
 * Created by keayuan on 2021/2/4.
 *
 * @author keayuan
 */
public class CollectionUtils {

    private CollectionUtils() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !isEmpty(collection);
    }

    public static <V> void forEach(Iterable<V> iterable, Consumer<V> consumer) {
        if (consumer == null) throw new NullPointerException();
        if (iterable == null) return;
        for (V v : iterable) consumer.accept(v);
    }

    public static <V> void forEach(Iterator<V> iterator, Consumer<V> consumer) {
        if (consumer == null) throw new NullPointerException();
        if (iterator == null) return;
        while (iterator.hasNext()) consumer.accept(iterator.next());
    }

    //================== List ==================
    public static <T> T getLast(List<T> collection) {
        if (isEmpty(collection)) return null;
        int size = collection.size();
        return collection.get(size - 1);
    }

    public static <T> T getFirst(List<T> collection) {
        if (isEmpty(collection)) return null;
        return collection.get(0);
    }

    public static int getSize(List<?> list) {
        return list == null ? 0 : list.size();
    }

    public static <T> T getQuietly(List<T> list, int position) {
        if (position < 0 || position >= getSize(list)) return null;
        return list.get(position);
    }

    public static <E> void forEach(List<E> list, BiConsumer<Integer, E> consumer) {
        if (consumer == null) throw new NullPointerException();
        if (isEmpty(list)) {
            return;
        }
        int size = getSize(list);
        for (int i = 0; i < size; i++) {
            consumer.accept(i, list.get(i));
        }
    }

    //================== Array ==================
    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] arr) {
        return !isEmpty(arr);
    }

    public static <T> int getSize(T[] arr) {
        return arr == null ? 0 : arr.length;
    }

    public static <E> E getFirst(E[] arr) {
        return isEmpty(arr) ? null : arr[0];
    }

    public static <E> E getLast(E[] arr) {
        return isEmpty(arr) ? null : arr[arr.length - 1];
    }

    public static <E> void forEach(E[] arr, Consumer<E> consumer) {
        if (consumer == null) throw new NullPointerException();
        if (isEmpty(arr)) {
            return;
        }
        for (E e : arr) {
            consumer.accept(e);
        }
    }

    public static <E> void forEach(E[] arr, BiConsumer<Integer, E> consumer) {
        if (consumer == null) throw new NullPointerException();
        if (isEmpty(arr)) {
            return;
        }
        int size = getSize(arr);
        for (int i = 0; i < size; i++) {
            consumer.accept(i, arr[i]);
        }
    }

    //================== Map ==================

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !isEmpty(map);
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<K, V> consumer) {
        if (consumer == null) throw new NullPointerException();
        if (map == null) return;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }
}
