package cn.keayuan.util;

import java.util.concurrent.Executor;

/**
 * Created by keayuan on 2019-12-02.
 *
 * @author keayuan
 */

public final class Platform {
    private static final IPlatform PLATFORM = findPlatform();
    private static ILog log;

    public static IPlatform get() {
        return PLATFORM;
    }

    Platform() {}

    private static IPlatform findPlatform() {
        try {
            if (Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null) > 0) {
                return new PlatformAndroid();
            }
        } catch (ClassNotFoundException ignored) {
        } catch (IllegalAccessException ignored) {
        } catch (NoSuchFieldException ignored) {
        }
        return new PlatformJava();
    }

    public static void runIO(Runnable runnable) {
        PLATFORM.runMain(runnable);
    }

    public static void runMain(Runnable runnable) {
        PLATFORM.runMain(runnable);
    }

    public static void setLogger(ILog iLog) {
        log = iLog;
    }

    public static ILog logger() {
        return log == null ? PLATFORM.logger() : log;
    }

    public static boolean isMainThread() {
        return PLATFORM.isMainThread();
    }

    public static Executor getMainExecutor() {
        return PLATFORM.getMainExecutor();
    }

    public interface IPlatform {
        default void runIO(Runnable run) {
            ThreadUtils.getIOPool().execute(run);
        }

        default void runMain(Runnable run) {
            getMainExecutor().execute(run);
        }

        default boolean isMainThread() {
            return true;
        }

        default Executor getMainExecutor() {
            return ThreadUtils.getSinglePool();
        }

        ILog logger();
    }
}
