/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.log.DefaultLog;
import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.ILogProvider;
import java.util.Objects;

public final class Logger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static ILog log = new DefaultLog("default");
    private static ILogProvider<?> provider = new DefaultLog("");

    private Logger() {
    }

    public static void setLogProvider(ILogProvider<?> provider) {
        Objects.requireNonNull(provider, "provider can't be null!!!");
        Logger.provider = provider;
        Logger.setLog(provider.getLogger("default"));
    }

    public static void setLog(ILog log) {
        Objects.requireNonNull(log, "log can't be null!!!");
        Logger.log = log;
    }

    public static ILog getLog() {
        return log;
    }

    public static ILog getLogger(Class<?> cls) {
        return Logger.getLogger(cls.getSimpleName());
    }

    public static ILog getLogger(String tag) {
        return provider.getLogger(tag);
    }

    public static boolean isLoggable(int priority) {
        return log.isLoggable(priority);
    }

    public static void v(String tag, String msg, Object ... obj) {
        log.log(2, tag, msg, obj);
    }

    public static void d(String tag, String msg, Object ... obj) {
        log.log(3, tag, msg, obj);
    }

    public static void i(String tag, String msg, Object ... obj) {
        log.log(4, tag, msg, obj);
    }

    public static void w(String tag, String msg, Object ... obj) {
        log.log(5, tag, msg, obj);
    }

    public static void e(String tag, String msg, Object ... obj) {
        log.log(6, tag, msg, obj);
    }

    public static void log(int priority, Runnable runnable) {
        if (Logger.isLoggable(priority)) {
            runnable.run();
        }
    }

    public static void log(int priority, String tag, String msg, Object ... obj) {
        log.log(priority, tag, msg, obj);
    }
}

