/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import cn.keayuan.util.log.PLog;
import java.io.PrintWriter;
import java.io.StringWriter;

public interface ILog
extends PLog {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final ILog EMPTY = (priority, tag, msg, obj) -> {};

    default public String getTag() {
        return "default";
    }

    default public void v(String msg, Object ... obj) {
        if (this.isLoggable(2)) {
            this.log(2, this.getTag(), msg, obj);
        }
    }

    default public void d(String msg, Object ... obj) {
        if (this.isLoggable(3)) {
            this.log(3, this.getTag(), msg, obj);
        }
    }

    default public void i(String msg, Object ... obj) {
        if (this.isLoggable(4)) {
            this.log(4, this.getTag(), msg, obj);
        }
    }

    default public void w(String msg, Object ... obj) {
        if (this.isLoggable(5)) {
            this.log(5, this.getTag(), msg, obj);
        }
    }

    default public void e(String msg, Object ... obj) {
        if (this.isLoggable(6)) {
            this.log(6, this.getTag(), msg, obj);
        }
    }

    default public boolean isLoggable(int priority) {
        return true;
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

