/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log;

import android.util.Log;
import cn.keayuan.util.log.ILog;
import cn.keayuan.util.log.PLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DefaultLog
implements ILog {
    private static final String[] NAME;
    private static final boolean isAndroid;
    private String tag;
    private int priority = 2;
    private StringBuilder builder;
    private PLog pLog;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.getDefault());

    public DefaultLog(String tag) {
        this.tag = tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setLog(PLog log) {
        this.pLog = log;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isLoggable(int priority) {
        return priority >= this.priority;
    }

    @Override
    public synchronized void log(int priority, String tag, String msg, Object ... obj) {
        if (priority > 7 || priority < 2) {
            throw new IllegalArgumentException("priority error " + priority);
        }
        if (this.pLog != null) {
            this.pLog.log(priority, tag, msg, obj);
            return;
        }
        if (this.builder == null) {
            this.builder = new StringBuilder();
        }
        this.builder.setLength(0);
        for (Object o : obj) {
            if (o instanceof Throwable) {
                this.builder.append(DefaultLog.getStackTraceString((Throwable)o));
            } else {
                this.builder.append(o);
            }
            this.builder.append(' ');
        }
        if (isAndroid) {
            Log.println((int)priority, (String)tag, (String)(msg + " " + this.builder.toString()));
        } else {
            System.out.println(this.dateFormat.format(new Date()) + " " + NAME[priority] + "/" + tag + ": " + msg + " " + this.builder.toString());
        }
        if (this.builder.length() > 5120) {
            this.builder = null;
        }
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    static {
        boolean hasLog;
        NAME = new String[]{"", "", "V", "D", "I", "W", "E", "A"};
        try {
            hasLog = Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null) > 0;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            hasLog = false;
        }
        isAndroid = hasLog;
        System.out.println("isAndroid " + isAndroid);
    }
}

