package cn.keayuan.util.log;

/**
 * 日志工具
 * <p>
 * Created by keayuan on 2022.12.28.
 *
 * @author keayuan
 */
public final class Logger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;

    private Logger() {
        throw new AssertionError();
    }

    private static ILog log = new DefaultLog("default");

    public static void setLog(ILog log) {
        if (log == null) {
            throw new NullPointerException("log can't be null!!!");
        }
        Logger.log = log;
    }

    public static ILog getLog() {
        return Logger.log;
    }

    public static ILog getLogger(Class<?> cls) {
        return getLogger(cls.getSimpleName());
    }

    public static ILog getLogger(String tag) {
        return new DefaultLog(tag);
    }

    public static void setDefaultTag(String tag) {
        if (log instanceof DefaultLog) {
            ((DefaultLog) log).setTag(tag);
        }
    }

    public static void setDefaultLevel(int priority) {
        if (log instanceof DefaultLog) {
            ((DefaultLog) log).setPriority(priority);
        }
    }

    public static boolean isLoggable(int priority) {
        return log.isLoggable(priority);
    }

    public static void v(String tag, String msg, Object... obj) {
        log.log(VERBOSE, tag, msg, obj);
    }

    public static void d(String tag, String msg, Object... obj) {
        log.log(DEBUG, tag, msg, obj);
    }

    public static void i(String tag, String msg, Object... obj) {
        log.log(INFO, tag, msg, obj);
    }

    public static void w(String tag, String msg, Object... obj) {
        log.log(WARN, tag, msg, obj);
    }

    public static void e(String tag, String msg, Object... obj) {
        log.log(ERROR, tag, msg, obj);
    }

    public static void log(int priority, Runnable runnable) {
        if (isLoggable(priority)) runnable.run();
    }

    public static void log(int priority, String tag, String msg, Object... obj) {
        log.log(priority, tag, msg, obj);
    }

}
