package cn.keayuan.util.log;

/**
 * Created by keayuan on 2021/9/17.
 *
 * @author keayuan
 */
public interface ILog extends PLog {

    default String getTag() {
        return "default";
    }

    default void v(String msg, Object... obj) {
        if (isLoggable(Logger.VERBOSE)) log(Logger.VERBOSE, getTag(), msg, obj);
    }

    default void d(String msg, Object... obj) {
        if (isLoggable(Logger.DEBUG)) log(Logger.DEBUG, getTag(), msg, obj);
    }

    default void i(String msg, Object... obj) {
        if (isLoggable(Logger.INFO)) log(Logger.INFO, getTag(), msg, obj);
    }

    default void w(String msg, Object... obj) {
        if (isLoggable(Logger.WARN)) log(Logger.WARN, getTag(), msg, obj);
    }

    default void e(String msg, Object... obj) {
        if (isLoggable(Logger.ERROR)) log(Logger.ERROR, getTag(), msg, obj);
    }

    default boolean isLoggable(int priority) {
        return true;
    }

}
