/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.ui;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import cn.keayuan.util.log.PLog;
import cn.keayuan.util.log.ui.Log;
import cn.keayuan.util.log.ui.LogCache;
import cn.keayuan.util.log.ui.LogLifecycle;
import cn.keayuan.util.log.ui.LogView;

public class LogWidget {
    private static LogWidget instance;
    private LogView root;
    private final LogCache printer = new LogCache(){

        @Override
        protected void onRefresh(Log[] list) {
            LogWidget.this.root.updateList(list);
        }
    };

    private LogWidget() {
    }

    static LogWidget getInstance() {
        if (instance == null) {
            instance = new LogWidget();
        }
        return instance;
    }

    public static void setCacheSize(int size) {
        LogWidget.getInstance().printer.setCacheMax(size);
    }

    public static void init(Application context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        context.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)LogLifecycle.getInstance());
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)LogLifecycle.getInstance());
    }

    void attach(Activity activity) {
        if (this.root == null) {
            this.root = new LogView((Context)activity);
            this.root.setFilter(this.printer);
        }
        if (this.root.getParent() != null) {
            ((ViewGroup)this.root.getParent()).removeView((View)this.root);
        }
        ViewGroup group = (ViewGroup)activity.findViewById(0x1020002);
        group.addView((View)this.root);
    }

    public static PLog getPrinter() {
        return LogWidget.getInstance().printer;
    }
}

