/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.ArcShape;
import android.graphics.drawable.shapes.Shape;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import cn.keayuan.util.log.ui.Log;
import cn.keayuan.util.log.ui.ViewFilter;

class LogView
extends FrameLayout {
    private static final String[] LEVEL = new String[]{"Verbose", "Debug", "Info", "Warn", "Error", "Assert"};
    private ListView listView;
    private FrameLayout contentView;
    private TextView floatView;
    private ViewFilter filter;
    private int level;
    private String content;
    private boolean isBottom;
    private Log[] mList;
    private BaseAdapter adapter = new BaseAdapter(){

        public int getCount() {
            return LogView.this.mList == null ? 0 : LogView.this.mList.length;
        }

        public Log getItem(int position) {
            return LogView.this.mList == null ? null : LogView.this.mList[position];
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Log log;
            if (convertView == null) {
                convertView = new TextView(LogView.this.getContext());
                ((TextView)convertView).setTextSize(2, 12.0f);
            }
            if ((log = this.getItem(position)) != null) {
                TextView view = (TextView)convertView;
                view.setText(log.getContent());
                view.setTextColor(log.color());
            }
            return convertView;
        }
    };

    public LogView(Context context) {
        this(context, null);
    }

    public LogView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LogView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.initView();
    }

    private void initView() {
        this.contentView = new FrameLayout(this.getContext());
        this.contentView.setBackgroundColor(-1);
        this.contentView.setVisibility(8);
        this.initFilterView();
        this.listView = new ListView(this.getContext());
        this.listView.setDivider((Drawable)new ColorDrawable(0x30000000));
        this.listView.setDividerHeight(this.dpToPx(1));
        this.listView.setSelector((Drawable)new ColorDrawable(0));
        this.listView.setAdapter((ListAdapter)this.adapter);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        lp.topMargin = this.dpToPx(40);
        this.contentView.addView((View)this.listView, (ViewGroup.LayoutParams)lp);
        this.addView((View)this.contentView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.getResources().getDisplayMetrics().heightPixels * 2 / 3));
        this.initFloatView();
    }

    private void initFilterView() {
        LinearLayout filterView = new LinearLayout(this.getContext());
        filterView.setOrientation(0);
        filterView.setBackgroundColor(-2138535800);
        ImageView image = new ImageView(this.getContext());
        image.setScaleType(ImageView.ScaleType.CENTER);
        image.setPadding(this.dpToPx(4), 0, this.dpToPx(4), 0);
        image.setImageResource(17301564);
        image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogView.this.filter(true);
            }
        });
        LinearLayout.LayoutParams llp = new LinearLayout.LayoutParams(this.dpToPx(36), -1);
        filterView.addView((View)image, (ViewGroup.LayoutParams)llp);
        image = new ImageView(this.getContext());
        image.setScaleType(ImageView.ScaleType.CENTER);
        image.setImageResource(17301506);
        image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogView.this.isBottom = !LogView.this.isBottom;
                v.setBackgroundColor(LogView.this.isBottom ? -7829368 : 0);
                LogView.this.updateList(LogView.this.mList);
            }
        });
        image.performClick();
        filterView.addView((View)image, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.dpToPx(36), -1));
        Spinner spinner = new Spinner(this.getContext());
        spinner.setAdapter((SpinnerAdapter)new ArrayAdapter(this.getContext(), 17367048, (Object[])LEVEL));
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                LogView.this.level = position;
                LogView.this.filter(false);
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        filterView.addView((View)spinner, this.dpToPx(120), this.dpToPx(40));
        EditText editText = new EditText(this.getContext());
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                LogView.this.content = s.toString();
                LogView.this.filter(false);
            }

            public void afterTextChanged(Editable s) {
            }
        });
        llp = new LinearLayout.LayoutParams(0, -2, 1.0f);
        llp.gravity = 5;
        filterView.addView((View)editText, (ViewGroup.LayoutParams)llp);
        this.contentView.addView((View)filterView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.dpToPx(40)));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initFloatView() {
        this.floatView = new TextView(this.getContext());
        this.floatView.setText((CharSequence)"log");
        this.floatView.setGravity(17);
        this.floatView.setTextColor(-1);
        this.floatView.setTextSize(18.0f);
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new ArcShape(0.0f, 360.0f));
        drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(-1610566145, PorterDuff.Mode.SRC_IN));
        this.floatView.setBackgroundDrawable((Drawable)drawable2);
        this.floatView.setOnTouchListener(new View.OnTouchListener(){
            PointF last = new PointF();
            PointF move = new PointF();
            PointF parentSize = null;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        if (this.parentSize == null) {
                            this.parentSize = new PointF((float)((View)v.getParent()).getWidth(), (float)((View)v.getParent()).getHeight());
                        }
                        this.last = new PointF(event.getX(), event.getY());
                        this.move.set(0.0f, 0.0f);
                        return true;
                    }
                    case 2: {
                        this.move.x += event.getX() - this.last.x;
                        this.move.y += event.getY() - this.last.y;
                        float newX = v.getX() + event.getX() - this.last.x;
                        float newY = v.getY() + event.getY() - this.last.y;
                        if (newX > 0.0f && newX < this.parentSize.x - (float)v.getWidth()) {
                            v.setX(newX);
                        }
                        if (!(newY > 0.0f) || !(newY < this.parentSize.y - (float)v.getHeight())) break;
                        v.setY(newY);
                        break;
                    }
                    case 1: {
                        if (v.getX() < this.parentSize.x / 2.0f) {
                            v.setX(0.0f);
                        } else {
                            v.setX(this.parentSize.x - (float)v.getWidth());
                        }
                        if (!(Math.abs(this.move.x) < 5.0f) && !(Math.abs(this.move.y) < 5.0f)) break;
                        int show = LogView.this.contentView.getVisibility();
                        LogView.this.contentView.setVisibility(show == 0 ? 8 : 0);
                    }
                }
                return true;
            }
        });
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.dpToPx(48), this.dpToPx(48));
        lp.gravity = 21;
        this.addView((View)this.floatView, (ViewGroup.LayoutParams)lp);
    }

    private int dpToPx(int dp) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)dp + 0.5f);
    }

    void setFilter(ViewFilter filter) {
        this.filter = filter;
    }

    private void filter(boolean clear) {
        if (this.filter != null) {
            this.filter.onFilter(clear, this.level, this.content);
        }
    }

    public void updateList(Log[] data) {
        if (data == null) {
            data = new Log[]{};
        }
        this.mList = data;
        this.adapter.notifyDataSetChanged();
        if (this.isBottom && this.mList.length > 0) {
            this.listView.smoothScrollToPosition(this.mList.length - 1);
        }
    }
}

