/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.ui;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import cn.keayuan.util.log.PLog;
import cn.keayuan.util.log.ui.Log;
import cn.keayuan.util.log.ui.ViewFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

abstract class LogCache
implements PLog,
ViewFilter {
    private static int maxSize = 262144;
    private static final int WHAT_ADD = 2001;
    private static final int WHAT_CLEAR = 2002;
    private static final int WHAT_FILTER = 2003;
    private ConcurrentLinkedQueue<Log> mCache = new ConcurrentLinkedQueue();
    private AtomicInteger cacheSize = new AtomicInteger();
    private List<Log> mList = new ArrayList<Log>();
    private int mLevel = 0;
    private String filterContent;
    private HandlerThread mThreadHandler;
    private WorkHandler workHandler;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final ReentrantLock lock = new ReentrantLock(true);

    LogCache() {
    }

    void setCacheMax(int size) {
        maxSize = size;
    }

    @Override
    public void onFilter(boolean clear, int level, String content) {
        this.mLevel = level;
        this.filterContent = content;
        if (clear) {
            this.getWorkHandler().sendEmptyMessage(2002);
            return;
        }
        this.getWorkHandler().sendEmptyMessage(2003);
    }

    private Handler getWorkHandler() {
        if (this.mThreadHandler == null) {
            this.mThreadHandler = new HandlerThread("LogCache");
            this.mThreadHandler.start();
            this.workHandler = new WorkHandler(this.mThreadHandler.getLooper());
        }
        return this.workHandler;
    }

    public void log(int priority, String tag, String message, Object ... obj) {
        this.lock.lock();
        Message.obtain((Handler)this.getWorkHandler(), (int)2001, (Object)new Log(priority, tag, message)).sendToTarget();
        this.lock.unlock();
    }

    private void add(Log log) {
        while (this.cacheSize.get() + log.size > maxSize) {
            Log temp = this.mCache.poll();
            if (temp == null) continue;
            temp.markRemove();
            this.cacheSize.getAndAdd(-temp.size);
        }
        this.mCache.offer(log);
        for (int i = 0; i < this.mList.size() && this.mList.get((int)i).isRemove; ++i) {
            this.mList.remove(0);
            --i;
        }
        if (log.priority >= this.mLevel && log.checkSpan()) {
            this.mList.add(log);
        }
        this.post();
    }

    private void filter() {
        this.mList.clear();
        Log.filter(this.filterContent);
        for (Log log : this.mCache) {
            if (log.priority < this.mLevel || !log.checkSpan()) continue;
            this.mList.add(log);
        }
        this.post();
    }

    private void post() {
        Log[] list = new Log[this.mList.size()];
        this.mList.toArray(list);
        this.mainHandler.post(() -> this.onRefresh(list));
    }

    protected abstract void onRefresh(Log[] var1);

    private class WorkHandler
    extends Handler {
        public WorkHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2001: {
                    LogCache.this.add((Log)msg.obj);
                    break;
                }
                case 2003: {
                    LogCache.this.filter();
                    break;
                }
                case 2002: {
                    LogCache.this.mCache.clear();
                    LogCache.this.cacheSize.set(0);
                    LogCache.this.filter();
                }
            }
        }
    }
}

