/*
 * Decompiled with CFR 0.152.
 */
package cn.keayuan.util.log.ui;

import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Log {
    private static final String[] LEVEL = new String[]{"V", "D", "I", "W", "E", "A"};
    private static final int[] COLOR = new int[]{-9473179, -13272876, -15615185, -20137, -3524045, -65536};
    private static final int filterColor = -1610566145;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.US);
    private static final Date date = new Date();
    private static Pattern pattern;
    final int priority;
    final String tag;
    private CharSequence content;
    final int size;
    boolean isRemove = false;

    Log(int level, String tag, String message) {
        this.priority = level < 2 ? 0 : (level > 7 ? 5 : level - 2);
        this.tag = tag;
        date.setTime(System.currentTimeMillis());
        this.content = dateFormat.format(date) + " " + LEVEL[this.priority] + "/" + tag + ": " + message;
        this.size = this.content.toString().getBytes().length;
    }

    static void filter(String reg) {
        pattern = TextUtils.isEmpty((CharSequence)reg) ? null : Pattern.compile(reg, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean checkSpan() {
        if (pattern == null) {
            this.content = this.content.toString();
            return true;
        }
        Matcher matcher = pattern.matcher(this.content);
        boolean has = false;
        SpannableString ss = new SpannableString((CharSequence)this.content.toString());
        while (matcher.find()) {
            has = true;
            ss.setSpan((Object)new BackgroundColorSpan(-1610566145), matcher.start(), matcher.end(), 18);
        }
        if (has) {
            this.content = ss;
            return true;
        }
        this.content = this.content.toString();
        return false;
    }

    CharSequence getContent() {
        return this.content;
    }

    int color() {
        return COLOR[this.priority];
    }

    void markRemove() {
        this.isRemove = true;
    }

    public String toString() {
        return this.content.toString();
    }
}

